<?php

namespace App\Filament\App\Resources;

use App\Filament\App\Resources\AttendeeResource\Pages;
use App\Filament\App\Resources\AttendeeResource\RelationManagers;
use App\Models\Attendee;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;

class AttendeeResource extends Resource
{
    protected static ?string $model = Attendee::class;

    protected static ?string $navigationIcon = 'heroicon-o-user-group';

    protected static ?string $navigationGroup = 'My Folder';

    protected static bool $shouldRegisterNavigation = false;

    protected static ?int $navigationSort = 2;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                // Forms\Components\TextInput::make('card_id')
                //     ->required()
                //     ->numeric(),
                // Forms\Components\TextInput::make('user_id')
                //     ->required()
                //     ->numeric(),
                Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(128)
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('phone_no')
                    ->tel()
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('people_no')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('timeslots')
                    ->maxLength(128),
                Forms\Components\TextInput::make('time_arrival'),
            ]);
    }

    public static function table(Table $table): Table
    {
        $userId = Auth::id();
        $table->query(Attendee::where('user_id', $userId));

        return $table
            ->columns([
                // Tables\Columns\TextColumn::make('card_id')
                //     ->numeric()
                //     ->sortable(),
                // Tables\Columns\TextColumn::make('user_id')
                //     ->numeric()
                //     ->sortable(),
                Tables\Columns\TextColumn::make('name')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('phone_no')
                    ->searchable(),
                Tables\Columns\TextColumn::make('people_no')
                    ->numeric()
                    ->sortable(),
                // Tables\Columns\TextColumn::make('timeslots')
                //     ->searchable(),
                Tables\Columns\TextColumn::make('time_arrival'),
                // Tables\Columns\TextColumn::make('created_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
                // Tables\Columns\TextColumn::make('updated_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\ViewAction::make(),
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ])
            ->emptyStateActions([
                // Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            // 'index' => Pages\ListAttendees::route('/'),
            // 'create' => Pages\CreateAttendee::route('/create'),
            // 'view' => Pages\ViewAttendee::route('/{record}'),
            // 'edit' => Pages\EditAttendee::route('/{record}/edit'),
        ];
    }
}
