<?php

namespace App\Filament\App\Resources;

use Filament\Forms\Components\Checkbox;
use Illuminate\Support\Facades\Auth;
use App\Filament\App\Resources\CardResource\Pages;
use App\Models\Card;
use App\Models\Theme;
use App\Models\Purchase;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TimePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Toggle;
use Filament\Tables\Columns\ViewColumn;
use Filament\Forms\Components\ViewField;
use PHPUnit\Event\Code\Test;

class CardResource extends Resource
{
    protected static ?string $model = Card::class;



    protected static ?string $navigationIcon = 'heroicon-o-envelope-open';

    protected static ?string $navigationLabel = 'Kad Kahwin';

    protected static ?string $navigationGroup = 'My Folder';

    protected static ?int $navigationSort = 1;

    public static function form(Form $form): Form
    {
        $userId = Auth::user()->id;
        $rsvp_field = Textarea::make('rsvp_timeslots')->hidden();

        if ($form->getRecord()) {
            $card = $card = $form->model;
            if ($card->user_id != $userId) {
                abort(403);
            }
            if (!$card->isOldFormatRSVP()) {
                $rsvp_field = Forms\Components\Builder::make('rsvp_timeslots')
                    ->label(__('RSVP Timeslots Untuk Kehadiran'))
                    ->blocks([
                        Forms\Components\Builder\Block::make('timeslots')
                            ->schema([
                                TextInput::make('timeslot')
                                    ->label('Time')
                                    ->required(),
                                Checkbox::make('on')
                                    ->label('Active')
                                    ->default(true)
                                    ->required(),
                            ])
                            ->columns(1),
                    ])
                    ->addActionLabel('Tambah Timeslot')
                    ->columnSpanFull();
            }
        }

        $purchases = Purchase::where('user_id', $userId)->pluck('theme_code');
        $purchasesAndDefaults = $purchases->push('default_modern');
        $themes = Theme::whereIn('code', $purchasesAndDefaults)->pluck('name', 'code');

        return $form->schema([
            Hidden::make('user_id')
                ->required()
                ->default($userId),
            Select::make('theme_code')
                ->label(__('Design Theme'))
                ->native(false)
                ->options($themes)
                ->columnSpanFull()
                ->reactive()
                ->default('default_modern'),
            Tabs::make('')
                ->tabs([
                    Tabs\Tab::make('Pegantin')
                        ->icon('heroicon-s-users')
                        ->schema([
                            TextInput::make('title')
                                ->maxLength(512)
                                ->label(__('Tajuk Majlis'))
                                ->placeholder(__('Contoh: Walimatulurus/Majlis Kesyukuran')),
                            DatePicker::make('date_masihi')
                                ->label(__('Tarikh Majlis'))
                                ->required(),
                            FileUpload::make('custom_design')
                                ->label('Upload Custom Design Anda')
                                ->directory('cards/custom_design')
                                ->disk('public')
                                ->visible(function (callable $get) {
                                    return $get('theme_code') === 'custom'; // Show only if theme_code is 'custom'
                                })
                                ->image()
                                ->imageEditor()
                                ->columnSpanFull(),
                            Section::make('Lelaki')
                                ->description('Nama pendek & nama penuh wajib diisi.')
                                ->schema([
                                    TextInput::make('male_short_name')
                                        ->required()
                                        ->label(__('Nama Pendek'))
                                        ->maxLength(128),
                                    TextInput::make('male_full_name')
                                        ->required()
                                        ->label(__('Nama Penuh'))
                                        ->maxLength(512),
                                ])
                                ->columnSpan(1),
                            Section::make('Perempuan')
                                ->description('Nama pendek & nama penuh wajib diisi.')
                                ->schema([
                                    TextInput::make('female_short_name')
                                        ->required()
                                        ->label(__('Nama Pendek'))
                                        ->maxLength(128),
                                    TextInput::make('female_full_name')
                                        ->required()
                                        ->label(__('Nama Penuh'))
                                        ->maxLength(512),
                                ])
                                ->columnSpan(1),
                        ])
                        ->columns(2),
                    Tabs\Tab::make('Majlis')
                        ->icon('heroicon-s-home')
                        ->schema([
                            Section::make('Waktu & Tarikh')
                                ->schema([
                                    TextInput::make('date_hijrah')
                                        ->label(__('Tarikh Hijrah'))
                                        ->columnSpanFull()
                                        ->maxLength(128),
                                    TimePicker::make('time_start')->label(__('Masa Mula')),
                                    TimePicker::make('time_end')->label(__('Masa Tamat')),
                                ])
                                ->columns(2)
                                ->columnSpan(1),
                            Section::make('Tempat')
                                ->schema([
                                    TextInput::make('location_name')
                                        ->label(__('Nama'))
                                        ->maxLength(512),
                                    Textarea::make('location_address')
                                        ->label(__('Alamat'))
                                        ->maxLength(65535)
                                        ->columnSpanFull(),
                                    TextInput::make('location_map_url')
                                        ->label(__('Koordinat Google Map'))
                                        ->maxLength(512)
                                        ->columnSpanFull(),
                                ])
                                ->columnSpan(1),
                        ])
                        ->columns(2),
                    Tabs\Tab::make('Undangan')
                        ->icon('heroicon-s-calendar-days')
                        ->schema([
                            Section::make('Ibu Bapa Pihak Lelaki')
                                ->description('Ibu bapa pihak pengantin lelaki.')
                                ->schema([
                                    TextInput::make('father_name')
                                        ->label(__('Nama Bapa'))
                                        ->maxLength(512),
                                    TextInput::make('mother_name')
                                        ->label(__('Nama Ibu'))
                                        ->maxLength(512),
                                ])
                                ->columnSpan(1),
                            Section::make('Ibu Bapa Pihak Perempuan')
                                ->description('Ibu bapa pihak pengantin perempuan.')
                                ->schema([
                                    TextInput::make('father_name_2')
                                        ->label(__('Nama Bapa'))
                                        ->maxLength(512),
                                    TextInput::make('mother_name_2')
                                        ->label(__('Nama Ibu'))
                                        ->maxLength(512),
                                ])
                                ->columnSpan(1),
                            Section::make('Orang Untuk Dihubungi')
                                ->description('Sila isi no.telefon tanpa sebarang jarak atau tanda dash.')
                                ->schema([
                                    TextInput::make('contact_name_1')
                                        ->label(__('Nama'))
                                        ->maxLength(128),
                                    TextInput::make('contact_phone_1')
                                        ->label(__('No.Telefon'))
                                        ->tel()
                                        ->maxLength(128),
                                    TextInput::make('contact_name_2')
                                        ->label(__('Nama'))
                                        ->maxLength(128),
                                    TextInput::make('contact_phone_2')
                                        ->label(__('No.Telefon'))
                                        ->tel()
                                        ->maxLength(128),
                                ])
                                ->columns(2)
                                ->columnSpan(1),
                            Section::make('Aturcara')
                                ->description('Contoh: Makan Beradap - 12:30 PM.')
                                ->schema([TextInput::make('program_name_1')->maxLength(128), TextInput::make('program_time_1')->maxLength(128), TextInput::make('program_name_2')->maxLength(128), TextInput::make('program_time_2')->maxLength(128), TextInput::make('program_name_3')->maxLength(128), TextInput::make('program_time_3')->maxLength(128)])
                                ->columns(2)
                                ->columnSpan(1),
                        ])
                        ->columns(2),
                    Tabs\Tab::make('Addon')
                        ->icon('heroicon-s-squares-plus')
                        ->schema([
                            Section::make('Galeri')
                                ->description('Gambar pengantin atau lokasi majlis.')
                                ->schema([
                                    FileUpload::make('image_1')
                                        ->label('')
                                        ->directory('cards/gallery_images')
                                        ->disk('public')
                                        ->image()
                                        ->imageEditor(),
                                    FileUpload::make('image_2')
                                        ->label('')
                                        ->directory('cards/gallery_images')
                                        ->disk('public')
                                        ->image()
                                        ->imageEditor(),
                                    FileUpload::make('image_3')
                                        ->label('')
                                        ->directory('cards/gallery_images')
                                        ->disk('public')
                                        ->image()
                                        ->imageEditor(),
                                ])
                                ->columns(3),
                            Section::make('Money Gift')
                                ->description('Maklumat untuk terima ')
                                ->schema([
                                    TextInput::make('money_gift_bank_name')
                                        ->label(__('Nama Bank'))
                                        ->maxLength(128),
                                    TextInput::make('money_gift_bank_account_no')
                                        ->label(__('No.Akaun Bank'))
                                        ->maxLength(128),
                                    FileUpload::make('money_gift_qr_code_image')
                                        ->label(__('QR Code'))
                                        ->directory('cards/qr_code_images')
                                        ->disk('public')
                                        ->image()
                                        ->imageEditor(),
                                ])
                                ->columns(3),
                            Textarea::make('youtube_url')
                                ->label(__('Youtube URL'))
                                ->maxLength(65535)
                                ->columnSpanFull(),
                            FileUpload::make('bg_music')
                                ->label(__('Background Music'))
                                ->maxSize(8000)
                                ->directory('cards/bg_music')
                                ->disk('public'),
                            Textarea::make('zoom_url')
                                ->maxLength(65535)
                                ->hidden()
                                ->columnSpanFull(),
                            Textarea::make('rsvp_timeslots')
                                ->hidden()
                                ->columnSpanFull(),
                        ]),
                    Tabs\Tab::make('RSVP')
                        ->icon('heroicon-s-user-group')
                        ->schema([
                            ViewField::make('attendees')
                                ->label(__('Kehadiran'))
                                ->view('filament.forms.components.view-card-attendees')
                                ->columnSpanFull(),
                            $rsvp_field,
                        ]),
                ])->columnSpanFull(),
            Toggle::make('side')
                ->label(__('Aktifkan ini untuk majlis pihak pengantin perempuan: Nama pengantin perempuan & ibu bapa akan menjadi keutamaan.'))
                ->columnSpanFull(),

            // ViewField::make('preview')
            //     ->label(__('Preview'))
            //     ->view('filament.forms.components.preview-card')
            //     ->columnSpan(1),
        ]);
    }

    public static function table(Table $table): Table
    {
        $userId = Auth::id();
        $table->query(Card::where('user_id', $userId)->orderBy('date_masihi', 'desc'));

        return $table
            ->columns([
                Tables\Columns\Layout\Grid::make()
                    ->schema([
                        ViewColumn::make('id')->view('tables.columns.cards.listing-card')
                            ->columnSpanFull(),
                    ]),
            ])
            ->contentGrid([
                'md' => 2,
                'xl' => 3,
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\ViewAction::make(),
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ])
            ->recordUrl(null)
            ->emptyStateActions([Tables\Actions\CreateAction::make()]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCards::route('/'),
            'create' => Pages\CreateCard::route('/create'),
            // 'view' => Pages\ViewCard::route('/{record}'),
            'edit' => Pages\EditCard::route('/{record}/edit'),
        ];
    }
}
