<?php

namespace App\Filament\App\Resources\CardResource\Pages;

use App\Filament\App\Resources\CardResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class CreateCard extends CreateRecord
{
    protected static string $resource = CardResource::class;

    protected ?string $heading = 'Buat Kad Kahwin';

    protected static bool $canCreateAnother = false;

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    public function mount(): void
    {
        // $user = User::find(auth()->user()->id);
        // $cards = $user->cards;
        // $maxCards = $user->purchases->count() + 1;

        // if ($cards->count() >= $maxCards) {
        //     $this->redirect('/app');
        // }
        $this->data['user_id'] = Auth::user()->id;
        $this->data['side'] = false;
        $this->data['theme_code'] = 'default_modern';
        $this->data['bg_music'] = null;
        $this->data['money_gift_qr_code_image'] = null;
        $this->data['image_1'] = null;
        $this->data['image_2'] = null;
        $this->data['image_3'] = null;
    }
}
