<?php

namespace App\Filament\App\Resources\CardResource\Widgets;

use Filament\Widgets\Widget;
use App\Models\User;

class CardOverview extends Widget
{
    protected static string $view = 'filament.app.resources.card-resource.widgets.card-overview';

    protected int | string | array $columnSpan = 'full';

    public $purchases, $cards, $combos, $maxCards, $displayedCards;

    public function mount()
    {
        $user = User::find(auth()->user()->id);

        $this->purchases = $user->purchases;
        $this->cards = $user->cards->sortByDesc('date_masihi');
        $this->combos = $user->combos;

        // The no of purchases + 1 is the max no of cards a user can have
        $this->maxCards = $user->purchases->count() + 1;
        $this->displayedCards = $this->cards->take(2);
    }

}
