<?php

namespace App\Filament\App\Resources;

use Auth;
use App\Filament\App\Resources\ComboCardResource\Pages;
use App\Filament\App\Resources\ComboCardResource\RelationManagers;
use App\Models\ComboCard;
use App\Models\Card;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Select;
use Illuminate\Support\Facades\URL;

class ComboCardResource extends Resource
{
    protected static ?string $model = ComboCard::class;

    protected static ?string $navigationIcon = 'heroicon-o-document-plus';

    protected static bool $shouldRegisterNavigation = false;

    protected static ?string $navigationGroup = 'My Folder';

    public static function form(Form $form): Form
    {
        $userId = Auth::user()->id;

        if ($form->getRecord()) {
            $combo = ComboCard::findOrFail($form->getRecord()->getKey());
            if ($combo->user_id != $userId) {
                abort(403);
            }
        }

        return $form
            ->schema([
                TextInput::make('user_id')
                    ->default(Auth::user()->id)
                    ->hidden(false),
                TextInput::make('title')
                    ->required()
                    ->placeholder(__('Title'))
                    ->columnSpanFull(),
                Textarea::make('description')
                    ->placeholder(__('Description'))
                    ->columnSpanFull(),
                Select::make('card_ids')
                    ->options(Card::where('user_id', Auth::user()->id)->pluck('title', 'id'))
                    ->multiple()
                    ->maxItems(2)
                    ->minItems(2)
                    ->required()
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('title')
                    ->label('Title')
                    ->description(fn(ComboCard $combo) => $combo->description ? $combo->description : 'No description')
                    ->searchable(),
                TextColumn::make('created_at')
                    ->label('Created')
                    ->dateTime('d/m/Y'),
            ])
            ->filters([
                // Tables\Filters\TrashedFilter::make(),
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            // 'index' => Pages\ListComboCards::route('/'),
            // 'create' => Pages\CreateComboCard::route('/create'),
            // 'edit' => Pages\EditComboCard::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                // SoftDeletingScope::class,
            ]);
    }
}
