<?php

namespace App\Filament\App\Resources\ComboCardResource\Pages;

use App\Filament\App\Resources\ComboCardResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditComboCard extends EditRecord
{
    protected static string $resource = ComboCardResource::class;

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }
}
