<?php

namespace App\Filament\App\Resources\GenericCardResource\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use App\Models\User;

class GenericCardOverview extends BaseWidget
{
    protected static string $view = 'filament.app.resources.generic-card-resource.widgets.generic-card-overview';

    protected int | string | array $columnSpan = 'full';

    public $purchases, $cards, $maxCards, $displayedCards;

    public function mount()
    {
        $user = User::find(auth()->user()->id);

        $this->purchases = $user->purchases;
        $this->cards = $user->genericCards->sortByDesc('date');

        // The no of purchases + 1 is the max no of cards a user can have
        $this->maxCards = $user->purchases->count() + 1;
        $this->displayedCards = $this->cards->take(2);
    }

}
