<?php

namespace App\Filament\App\Resources;

use Illuminate\Support\Facades\Auth;
use App\Filament\App\Resources\PurchaseResource\Pages;
use App\Filament\App\Resources\PurchaseResource\RelationManagers;
use App\Models\Purchase;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\ViewField;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Repeater;

class PurchaseResource extends Resource
{
    protected static ?string $model = Purchase::class;

    protected static ?string $navigationIcon = 'heroicon-o-newspaper';

    protected static ?string $navigationGroup = 'My Folder';

    protected static ?int $navigationSort = 3;

    public static function form(Form $form): Form
    {
        $userId = Auth::user()->id;

        $typeField = TextInput::make('theme_code')
            ->label('Type')
            ->maxLength(128);

        if($form->getRecord()) {
            $purchase = Purchase::findOrFail($form->getRecord()->getKey());
            if ($purchase->user_id != $userId) {
                abort(403);
            }
            if ($purchase->theme_code == 'service_print_card') {
                $typeField = Repeater::make('metas')
                    ->label('Details')
                    ->relationship()
                    ->schema([
                        TextInput::make('value')
                            ->label(fn ($record) => ucwords(str_replace("_", " ", $record->key))),
                    ]);
            }
        }

        return $form
            ->schema([
                ViewField::make('theme_code')
                    ->label('')
                    ->hidden(fn ($record) => $record->theme_code == 'service_print_card')
                    ->view('forms.components.theme-preview'),
                Section::make('Details')
                    ->columns(1)
                    ->columnSpan(1)
                    ->schema([
                        DateTimePicker::make('created_at')
                            ->label('Date'),
                        TextInput::make('bill_id')
                            ->label('Bill ID')
                            ->maxLength(128),
                        TextInput::make('paid_price')
                            ->label('Price')
                            ->numeric()
                            ->prefix('MYR'),
                        $typeField,
                ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        $userId = Auth::id();
        $table->query(Purchase::where('user_id', $userId));

        return $table
            ->columns([
                TextColumn::make('created_at')
                    ->label('Date')
                    ->dateTime('d/m/Y')
                    ->sortable(),
                TextColumn::make('bill_id')
                    ->label('Bill ID')
                    ->searchable(),
                // TextColumn::make('theme.name')
                //     ->label('Theme Code')
                //     ->searchable(),
                TextColumn::make('paid_price')
                    ->label('Price')
                    ->money('MYR')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\ViewAction::make(),
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ])
            ->emptyStateActions([
                // Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPurchases::route('/'),
            // 'create' => Pages\CreatePurchase::route('/create'),
            'view' => Pages\ViewPurchase::route('/{record}'),
            // 'edit' => Pages\EditPurchase::route('/{record}/edit'),
        ];
    }
}
