<?php

namespace App\Filament\App\Resources;

use App\Filament\App\Resources\ThemeResource\Pages;
use App\Filament\App\Resources\ThemeResource\RelationManagers;
use App\Models\Theme;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\ViewColumn;
use Illuminate\Support\Facades\URL;

class ThemeResource extends Resource
{
    protected static ?string $model = Theme::class;

    protected static ?string $navigationIcon = 'heroicon-o-swatch';

    protected static bool $shouldRegisterNavigation = false;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('code')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('category')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('font_primary')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('font_secondary')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('style_primary')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('color')
                    ->required()
                    ->maxLength(128),
                Forms\Components\TextInput::make('price')
                    ->required()
                    ->numeric()
                    ->prefix('$'),
                Forms\Components\Textarea::make('description')
                    ->maxLength(65535)
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                // Tables\Columns\TextColumn::make('code')
                //     ->searchable(),
                ViewColumn::make('Preview')->view('tables.columns.theme-preview')
                    ->url(fn (Theme $record): string => URL::route('theme.preview', $record->code)),
                Tables\Columns\TextColumn::make('name')
                    ->url(fn (Theme $record): string => URL::route('theme.preview', $record->code))
                    ->description(fn (Theme $record): string => $record->category),

                // Tables\Columns\TextColumn::make('category')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('font_primary')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('font_secondary')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('style_primary')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('color')
                //     ->searchable(),
                Tables\Columns\TextColumn::make('price')
                    ->money('myr')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\ViewAction::make(),
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ])
            ->emptyStateActions([
                // Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            // 'index' => Pages\ListThemes::route('/'),
            // 'create' => Pages\CreateTheme::route('/create'),
            // 'view' => Pages\ViewTheme::route('/{record}'),
            // 'edit' => Pages\EditTheme::route('/{record}/edit'),
        ];
    }
}
