<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AdvertismentResource\Pages;
use App\Filament\Resources\AdvertismentResource\RelationManagers;
use App\Models\Advertisment;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AdvertismentResource extends Resource
{
    protected static ?string $model = Advertisment::class;

    protected static ?string $navigationIcon = 'heroicon-o-tag';

    protected static ?string $navigationGroup = 'Business';

    protected static ?int $navigationSort = 4;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')
                    ->autofocus()
                    ->required()
                    ->label('Title'),
                Forms\Components\TextInput::make('link')
                    ->required()
                    ->label('Link'),
                Forms\Components\Textarea::make('content')
                    ->label('Content')
                    ->columnSpanFull(),
                Forms\Components\FileUpload::make('image')
                    ->directory('endorsement/promotion_images')
                    ->disk('public')
                    ->image(),
                Forms\Components\TextInput::make('order')
                    ->numeric()
                    ->label('Order')
                    ->hidden(),
                Forms\Components\Checkbox::make('is_active')
                    ->label('Active')
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\BooleanColumn::make('is_active')
                    ->label('Active')
                    ->sortable(),
                Tables\Columns\TextColumn::make('link')
                    ->url(fn (Advertisment $advertisment) => $advertisment->link)
                    ->label('Link')
                    ->sortable(),
                // Tables\Columns\TextColumn::make('order')
                //     ->sortable(),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAdvertisments::route('/'),
            'create' => Pages\CreateAdvertisment::route('/create'),
            'edit' => Pages\EditAdvertisment::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
