<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CardPrintServiceResource\Pages;
use App\Filament\Resources\CardPrintServiceResource\RelationManagers;
use App\Models\CardPrintService;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Select;

class CardPrintServiceResource extends Resource
{
    protected static ?string $model = CardPrintService::class;

    protected static ?string $navigationIcon = 'heroicon-o-printer';

    protected static ?string $navigationGroup = 'Business';

    protected static ?int $navigationSort = 2;

    public static function form(Form $form): Form
    {
        return $form->schema([
            Select::make('vendor_id')
                ->relationship('vendor', 'name')
                ->native(false)
                ->required(),
            TextInput::make('name')
                ->required()
                ->maxLength(255),
            Textarea::make('description')
                ->maxLength(65535)
                ->columnSpanFull(),
            Forms\Components\Builder::make('options')
                ->blocks([
                    Forms\Components\Builder\Block::make('printing_rates')
                    ->schema([
                        TextInput::make('pieces')
                            ->label('Card Pieces')
                            ->numeric()
                            ->required(),
                        TextInput::make('price')
                            ->label('Price (MYR)')
                            ->numeric()
                            ->required(),
                    ])
                    ->columns(2),
                ])
                ->columnSpanFull(),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('vendor_id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('name')->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([Tables\Actions\EditAction::make()])
            ->bulkActions([Tables\Actions\BulkActionGroup::make([Tables\Actions\DeleteBulkAction::make()])])
            ->emptyStateActions([Tables\Actions\CreateAction::make()]);
    }

    public static function getRelations(): array
    {
        return [
                //
            ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCardPrintServices::route('/'),
            'create' => Pages\CreateCardPrintService::route('/create'),
            'edit' => Pages\EditCardPrintService::route('/{record}/edit'),
        ];
    }
}
