<?php

namespace App\Filament\Resources;

use App\Filament\Resources\VendorResource\Pages;
use App\Filament\Resources\VendorResource\RelationManagers;
use App\Models\Vendor;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Select;

class VendorResource extends Resource
{
    protected static ?string $model = Vendor::class;

    protected static ?string $navigationIcon = 'heroicon-o-building-storefront';

    protected static ?string $navigationGroup = 'Business';

    protected static ?int $navigationSort = 3;

    public static function form(Form $form): Form
    {
        return $form->schema([
            TextInput::make('name')
                ->required()
                ->maxLength(255)
                ->columnSpanFull(),
            TextInput::make('slug')
                ->required()
                ->maxLength(255),
            Select::make('user_id')
                ->relationship('user', 'name')
                ->native(false)
                ->required(),
            FileUpload::make('logo_image')
                ->label('Logo Image')
                ->directory('vendor/logo_images')
                ->disk('public')
                ->image()
                ->imageEditor(),
            FileUpload::make('cover_image')
                ->label('Cover Image')
                ->directory('vendor/cover_images')
                ->disk('public')
                ->image()
                ->imageEditor(),
            TextInput::make('email')
                ->email()
                ->maxLength(255),
            TextInput::make('phone_no')
                ->tel()
                ->maxLength(255),
            TextInput::make('whatsapp_no')->maxLength(255),
            Select::make('state')
                ->options([
                    'Johor' => 'Johor',
                    'Kedah' => 'Kedah',
                    'Kelantan' => 'Kelantan',
                    'Kuala Lumpur' => 'Kuala Lumpur',
                    'Labuan' => 'Labuan',
                    'Melaka' => 'Melaka',
                    'Negeri Sembilan' => 'Negeri Sembilan',
                    'Pahang' => 'Pahang',
                    'Perak' => 'Perak',
                    'Perlis' => 'Perlis',
                    'Pulau Pinang' => 'Pulau Pinang',
                    'Putrajaya' => 'Putrajaya',
                    'Sabah' => 'Sabah',
                    'Sarawak' => 'Sarawak',
                    'Selangor' => 'Selangor',
                    'Terengganu' => 'Terengganu',
                ])
                ->native(false),
            Textarea::make('address')
                ->maxLength(65535)
                ->columnSpanFull(),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                // Tables\Columns\TextColumn::make('user_id')
                //     ->numeric()
                //     ->sortable(),
                Tables\Columns\TextColumn::make('name')->searchable(),
                // Tables\Columns\TextColumn::make('slug')
                //     ->url(fn (Vendor $vendor) => route('vendor.show', $vendor->slug))
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('email')->searchable(),
                // Tables\Columns\TextColumn::make('phone_no')->searchable(),
                // Tables\Columns\TextColumn::make('whatsapp_no')->searchable(),
                Tables\Columns\TextColumn::make('state')->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make()
                    ->url(fn (Vendor $vendor) => route('vendor.show', $vendor->slug)),
                Tables\Actions\EditAction::make(),
                // Tables\Actions\DeleteAction::make(),
                ])
            ->bulkActions([Tables\Actions\BulkActionGroup::make([Tables\Actions\DeleteBulkAction::make()])])
            ->emptyStateActions([Tables\Actions\CreateAction::make()]);
    }

    public static function getRelations(): array
    {
        return [
                //
            ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListVendors::route('/'),
            'create' => Pages\CreateVendor::route('/create'),
            'edit' => Pages\EditVendor::route('/{record}/edit'),
        ];
    }
}
