<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Exception;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;

class SocialLoginController extends Controller
{
    public function redirectToProvider($provider)
    {
        return Socialite::driver($provider)->redirect();
    }

    public function handleProviderCallback($provider)
    {
        try {
            if ($provider == 'twitter') {
                $user = Socialite::driver($provider)->user();
            } else {
                $user = Socialite::driver($provider)->stateless()->user();
            }
        } catch (Exception $e) {
            return redirect()->route('login')->with('error', 'Something went wrong. Please try again.');
        }

        $authUser = $this->findOrCreateUser($user, $provider);

        if (!$authUser) {
            return redirect()->route('auth.login')
                ->with('error', 'Your email (' . $user->email . ') already existed in our system. Please try to login with another account.');
        }

        Auth::login($authUser, true);

        return redirect()->intended(RouteServiceProvider::HOME);
    }


    /**
     * If a user has registered before using social auth, return the user
     * else, create a new user object.
     * @param  $user Socialite user object
     * @param $provider Social auth provider
     * @return  User
     */
    public function findOrCreateUser($user, $provider)
    {
        if ($authUser = User::where('email', $user->email)->first()) {
            if ($authUser->provider_id == $user->id)
                return $authUser;
            else {
                return false;
            }
        }
        //Create user
        return User::create([
            'name' => $user->name,
            'email' => $user->email,
            'password' => Hash::make(Str::random(24)),
            'provider' => $provider,
            'provider_id' => $user->id,
        ]);
    }

}
