<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Card;
use App\Models\ComboCard;
use App\Models\GenericCard;

class CardController extends Controller
{
    public function show($id)
    {
        $card = Card::find($id);

        if ($card->image_1 != null && strpos($card->image_1, 'cards/gallery_images') === false) {
            $card->image_1 = 'cards/gallery_images/' . $card->image_1;
        }
        if ($card->image_2 != null && strpos($card->image_2, 'cards/gallery_images') === false) {
            $card->image_2 = 'cards/gallery_images/' . $card->image_2;
        }
        if ($card->image_3 != null && strpos($card->image_3, 'cards/gallery_images') === false) {
            $card->image_3 = 'cards/gallery_images/' . $card->image_3;
        }

        if (strpos($card->youtube_url, 'watch?v=') !== false) {
            $card->youtube_url = str_replace('watch?v=', 'embed/', $card->youtube_url);
        }

        if (strpos($card->youtube_url, '?autoplay=1') !== false) {
            $card->youtube_url = str_replace('?autoplay=1', '', $card->youtube_url);
        }

        if (strpos($card->youtube_url, ' ') !== false) {
            $card->youtube_url = str_replace(' ', '', $card->youtube_url);
        }

        if (strpos($card->youtube_url, 'https://youtu.be/') !== false) {
            $card->youtube_url = str_replace('https://youtu.be/', 'https://www.youtube.com/embed/', $card->youtube_url);
        }

        $card->time_start = date('h:i A', strtotime($card->time_start));
        $card->time_end = date('h:i A', strtotime($card->time_end));
        $card->date_masihi = date('d M Y', strtotime($card->date_masihi));

        return view('cards.show', compact('card'));
    }

    public function combo($id)
    {
        $combo = ComboCard::find($id);
        $card = $combo->cards()->first();

        return view('cards.combo', compact('combo', 'card'));
    }

    public function showGeneric($id)
    {
        $card = GenericCard::find($id);

        $card->start_time = date('h:i A', strtotime($card->start_time));
        $card->end_time = date('h:i A', strtotime($card->end_time));
        $card->date = date('d M Y', strtotime($card->date));

        return view('cards.show_generic', compact('card'));
    }

    public function print($id)
    {
        $card = Card::find($id);

        return view('cards.print', compact('card'));
    }

    public function metaverse($id)
    {
        $card = Card::find($id);

        return view('cards.metaverse', compact('card'));
    }
}
