<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Theme;
use App\Models\Card;

class HomeController extends Controller
{
    public function index()
    {
        $themes = Theme::inRandomOrder()->limit(4)->get();
        return view('homes.index', compact('themes'));
    }

    public function themes()
    {
        $themes = Theme::orderByDesc('id')->whereNot('code', 'custom')->paginate(12);
        $popular_themes = Theme::where('is_popular', true)->whereNot('code', 'custom')->inRandomOrder()->limit(3)->get();
        return view('themes.index', compact('themes', 'popular_themes'));
    }

    public function theme($theme_code)
    {
        $theme = Theme::where('code', $theme_code)->first();
        $themes = Theme::where('code', '!=', $theme_code)->inRandomOrder()->limit(4)->get();
        return view('themes.show', compact('theme', 'themes'));
    }

    public function preview($theme_code)
    {
        $theme = Theme::where('code', $theme_code)->first();

        $card = Card::find(-101);
        $card->theme_code = $theme_code;
        $card->theme = $theme;

        if ($card->image_1 != null && strpos($card->image_1, 'cards/gallery_images') === false) {
            $card->image_1 = 'cards/gallery_images/' . $card->image_1;
        }
        if ($card->image_2 != null && strpos($card->image_2, 'cards/gallery_images') === false) {
            $card->image_2 = 'cards/gallery_images/' . $card->image_2;
        }
        if ($card->image_3 != null && strpos($card->image_3, 'cards/gallery_images') === false) {
            $card->image_3 = 'cards/gallery_images/' . $card->image_3;
        }

        $card->time_start = date('h:i A', strtotime($card->time_start));
        $card->time_end = date('h:i A', strtotime($card->time_end));
        $card->date_masihi = date('d M Y', strtotime($card->date_masihi));

        return view('cards.show', compact('card'));
    }

    public function contact()
    {
        return view('homes.contact');
    }

    public function about()
    {
        return view('homes.about');
    }

    public function promo()
    {
        return view('homes.promo');
    }

    public function terms()
    {
        return view('homes.terms');
    }

    public function privacy()
    {
        return view('homes.privacy');
    }
}
