<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Vendor;

class VendorController extends Controller
{
    public function show($slug)
    {
        $vendor = Vendor::where('slug', $slug)->firstOrFail();
        return view('vendors.show', compact('vendor'));
    }

    public function confirmOrder(Request $request)
    {
        $order = $request->order;
        $card = $request->card;
        $vendor = $request->vendor;

        $response = $this->sendWhatsAppMessage($order, $card, $vendor);

        return response()->json($response);
    }

    public function sendWhatsAppMessage($order, $card, $vendor) {
        $url = 'https://graph.facebook.com/v17.0/132754523261630/messages';
        $accessToken = config('constants.meta_access_token');
        $to = $vendor->phone_no;

        $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $accessToken,
                'Content-Type' => 'application/json',
            ])
            ->post($url, [
                'messaging_product' => 'whatsapp',
                'to' => $to,
                'type' => 'template',
                'template' => [
                    'name' => 'notify_vendor_order',
                    'language' => ['code' => 'en'],
                    'components' => [
                        [
                            'type' => 'body',
                            'parameters' => [
                                [
                                    'type' => 'text',
                                    'text' => $order->customer_name,
                                ],
                                [
                                    'type' => 'text',
                                    'text' => $order->customer_phone_no,
                                ],
                                [
                                    'type' => 'text',
                                    'text' => $order->quantity,
                                ],
                                [
                                    'type' => 'text',
                                    'text' => route('cards.print', $card->id),
                                ],
                                [
                                    'type' => 'text',
                                    'text' => $order->customer_address,
                                ],
                            ],
                        ],
                    ],
                ],
            ]);

        return $response->json();
    }
}
