<?php

namespace App\Livewire\Cards;

use Livewire\Component;
use App\Models\Advertisment;

class AdvertismentSection extends Component
{
    public $show_ads, $advertisment;

    public function mount()
    {
        $ads = Advertisment::orderedActive()->get();

        $this->advertisment = $ads->first();
        $this->show_ads = $ads->count() > 0 ? true : false;
    }

    public function countClick()
    {
        $this->advertisment->count += 1;
        $this->advertisment->save();
    }

    public function render()
    {
        return view('livewire.cards.advertisment-section');
    }
}
