<?php

namespace App\Livewire\Cards;

use Livewire\Component;

class PrintCheckout extends Component
{
    public $name, $email, $phone_no, $address, $card_amount, $retail_price, $discount, $paid_price;

    public function mount()
    {
        if(auth()->user()) {
            $this->name = auth()->user()->name;
            $this->email = auth()->user()->email;
            $this->card_amount = 500;
            $this->selectCardAmount();
        };
    }

    public function selectCardAmount()
    {
        $amount = $this->card_amount;
        if ($amount == 100) {
            $this->retail_price = 120;
            $this->discount = 20;
            $this->paid_price = 100;
        }
        if ($amount == 300) {
            $this->retail_price = 150;
            $this->discount = 30;
            $this->paid_price = 120;
        }
        if ($amount == 500) {
            $this->retail_price = 180;
            $this->discount = 50;
            $this->paid_price = 130;
        }
        if ($amount == 1000) {
            $this->retail_price = 210;
            $this->discount = 70;
            $this->paid_price = 140;
        }
    }

    public function render()
    {
        return view('livewire.cards.print-checkout');
    }
}
