<?php

namespace App\Livewire\Chatbot;

use App\Models\Card;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class AiAgent extends Component
{
    public $card,
        $current_step,
        $card_male_name_short,
        $card_male_name_full,
        $card_female_name_short,
        $card_female_name_full,
        $card_date,
        $form_disabled,
        $max_cards,
        $all_cards;

    public function mount()
    {
        $this->card = null;
        $this->current_step = 0;
        $this->form_disabled = '';
        $this->max_cards = Auth::user()->purchases->count() + 1;
        $this->all_cards = Auth::user()->cards->count();
    }

    public function step1()
    {
        $this->current_step = 1;
        if ($this->all_cards >= $this->max_cards) {
            $this->current_step = -1;
        }
    }

    public function step2()
    {
        $this->current_step = 2;
        $this->createNewcard();
        $this->form_disabled = 'disabled';
    }

    public function createNewcard() {
        $this->card = Card::create([
            'user_id' => Auth::user()->id,
            'theme_code' => 'default_modern',
            'male_short_name' => $this->card_male_name_short,
            'male_full_name' => $this->card_male_name_full,
            'female_short_name' => $this->card_female_name_short,
            'female_full_name' => $this->card_female_name_full,
            'date_masihi' => $this->card_date,
            'side' => 0
        ]);
    }

    public function render()
    {
        return view('livewire.chatbot.ai-agent');
    }
}
