<?php

namespace App\Livewire\Chatbot;

use Livewire\Component;

class ShowCardModal extends Component
{
    public $card, $reply;

    public function mount($card)
    {
        $this->card = $card;
        $this->reply = '';
    }

    public function ask($question_id)
    {
        if ($question_id == 1) {
            $start = date('h:i A', strtotime($this->card->time_start));
            $end = date('h:i A', strtotime($this->card->end_start));
            $time = '';
            if($start != null && $end != null){
                $time = "Dari pukul <b>" . date('h:i A', strtotime($this->card->time_start)) . "</b>
                sampai pukul <b>" . date('h:i A', strtotime($this->card->end_start)) . "</b>.";
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>Bila majlis?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>Majlis ini akan berlangsung pada <b>" . date('d M Y', strtotime($this->card->date_masihi)) . "</b>. " . $time . "</p>
                    <br>
                    <p>Tekan butang dibawah untuk Simpan tarikh majlis ke calendar anda:</p>
                    <button type='button'
                        class='p-2 bg-gray-200 hover:bg-gray-300 rounded-md w-full text-center mt-2 border border-gray-400 text-sm'
                        onclick='document.getElementById(`btn-add-to-calendar`).click()'>
                        <i class='fas fa-calendar-plus mr-2'></i>Add to Calendar
                    </button>
                </div>
            </div>";
        }
        if ($question_id == 2) {
            $address = '';
            $direction = '';
            if ($this->card->location_address != null && $this->card->location_address != '') {
                $address = "<p> Di alamat: " . $this->card->location_address . ".</p>";
            }
            if ($this->card->location_map_url != null && $this->card->location_map_url != null) {
                $direction = "<br>
                <p>Tekan butang dibawah untuk mendapatkan arah ke lokasi majlis:</p>
                <div class='grid grid-cols-2 mt-2 border border-gray-400 rounded-md w-full overflow-hidden text-sm'>
                    <a href='https://maps.google.com/maps?daddr=" . $this->card->location_map_url . "&navigate=yes'
                        class='p-2 bg-gray-200 hover:bg-gray-300 text-center border-r border-gray-400'>
                        <i class='fas fa-map-marker-alt mr-2'></i>Maps
                    </a>
                    <a href='https://waze.com/ul?q=" . $this->card->location_map_url . "&navigate=yes&zoom=17'
                        class='p-2 bg-gray-200 hover:bg-gray-300 text-center'>
                        <i class='fab fa-waze mr-2'></i>Waze
                    </a>
                </div>";
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>Dimana majlis?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>Majlis ini akan berlangsung di " . $this->card->location_name . ".</p>
                    " . $address . $direction . "
                </div>
            </div>";
        }
        if ($question_id == 3) {
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>Nama pengantin?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>Nama pengantin lelaki ialah " . $this->card->male_full_name . ".</p>
                    <br>
                    <p>Nama pengantin perempuan ialah " . $this->card->female_full_name . ".</p>
                </div>
            </div>";
        }
        if ($question_id == 4) {
            $inviter = '';
            if ($this->card->side) {
                if ($this->card->father_name_2 != null && $this->card->father_name_2 != '' && $this->card->mother_name_2 != null && $this->card->mother_name_2 != '') {
                    $inviter = $this->card->father_name_2 . ' & ' . $this->card->mother_name_2;
                } elseif ($this->card->father_name_2 != null && $this->card->father_name_2 != '') {
                    $inviter = $this->card->father_name_2;
                } elseif ($this->card->mother_name_2 != null && $this->card->mother_name_2 != '') {
                    $inviter = $this->card->mother_name_2;
                }
            } else {
                if ($this->card->father_name != null && $this->card->father_name != '' && $this->card->mother_name != null && $this->card->mother_name != '') {
                    $inviter = $this->card->father_name . ' & ' . $this->card->mother_name;
                } elseif ($this->card->father_name != null && $this->card->father_name != '') {
                    $inviter = $this->card->father_name;
                } elseif ($this->card->mother_name != null && $this->card->mother_name != '') {
                    $inviter = $this->card->mother_name;
                }
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>Siapa mengundang?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>Anda telah diundang oleh " . $inviter . ".</p>
                </div>
            </div>";
        }
        if ($question_id == 5) {
            $contact_1 = null;
            $contact_2 = null;
            if ($this->card->contact_name_1 != null && $this->card->contact_phone_1 != null) {
                $contact_1 = "<div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow mt-2'>
                        <p>" . $this->card->contact_name_1 . "</p>
                        <div class='flex mt-2 border border-gray-400 rounded-md w-full overflow-hidden text-sm'>
                            <a href='https://wa.me/6" . $this->card->contact_phone_1 . "'
                                class='py-2 px-4 bg-gray-200 hover:bg-gray-300 text-center border-r border-gray-400'>
                                <i class='fab fa-whatsapp mr-2'></i>WhatsApp
                            </a>
                            <a href='tel:" . $this->card->contact_phone_1 . "'
                                class='py-2 px-4 bg-gray-200 hover:bg-gray-300 text-center'>
                                <i class='fas fa-phone mr-2'></i>Telefon
                            </a>
                        </div>
                    </div>";
            }
            if ($this->card->contact_name_2 != null && $this->card->contact_phone_2 != null){
                $contact_2 = "<div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow mt-2'>
                    <p>" . $this->card->contact_name_2 . "</p>
                    <div class='flex mt-2 border border-gray-400 rounded-md w-full overflow-hidden text-sm'>
                        <a href='https://wa.me/6" . $this->card->contact_phone_2 . "'
                            class='py-2 px-4 bg-gray-200 hover:bg-gray-300 text-center border-r border-gray-400'>
                            <i class='fab fa-whatsapp mr-2'></i>WhatsApp
                        </a>
                        <a href='tel:" . $this->card->contact_phone_2 . "'
                            class='py-2 px-4 bg-gray-200 hover:bg-gray-300 text-center'>
                            <i class='fas fa-phone mr-2'></i>Telefon
                        </a>
                    </div>
                </div>";
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>Saya sesat jalan. Siapa boleh saya hubungi?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>Anda boleh WhatsApp atau telefon mereka ini:</p>
                </div>
                " . $contact_1 . "
                " . $contact_2 . "
            </div>";
        }

        $this->reply = $this->reply . $answer;
    }

    public function render()
    {
        return view('livewire.chatbot.show-card-modal');
    }

}
