<?php

namespace App\Livewire\Chatbot;

use Livewire\Component;

class ShowGenericCardModal extends Component
{
    public $card, $reply;

    public function mount($card)
    {
        $this->card = $card;
        $this->reply = '';
    }

    public function ask($question_id)
    {
        if ($question_id == 1) {
            $start = date('h:i A', strtotime($this->card->start_time));
            $end = date('h:i A', strtotime($this->card->end_time));
            $time = '';
            if($start != null && $end != null){
                $time = "From <b>" . date('h:i A', strtotime($this->card->start_time)) . "</b>
                until <b>" . date('h:i A', strtotime($this->card->end_time)) . "</b>.";
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>When is it?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>The event will happen on <b>" . date('d M Y', strtotime($this->card->date)) . "</b>. " . $time . "</p>
                    <br>
                    <p>Press the button below to add the event in your calendar:</p>
                    <button type='button'
                        class='p-2 bg-gray-200 hover:bg-gray-300 rounded-md w-full text-center mt-2 border border-gray-400 text-sm'
                        onclick='document.getElementById(`btn-add-to-calendar`).click()'>
                        <i class='fas fa-calendar-plus mr-2'></i>Add to Calendar
                    </button>
                </div>
            </div>";
        }
        if ($question_id == 2) {
            $address = '';
            $direction = '';
            if ($this->card->location_address != null && $this->card->location_address != '') {
                $address = "<p> Located at: " . $this->card->location_address . ".</p>";
            }
            if ($this->card->location_coordinate != null && $this->card->location_coordinate != null) {
                $direction = "<br>
                <p>Press the button below to get direction to the location</p>
                <div class='grid grid-cols-2 mt-2 border border-gray-400 rounded-md w-full overflow-hidden text-sm'>
                    <a href='https://maps.google.com/maps?daddr=" . $this->card->location_coordinate . "&navigate=yes'
                        class='p-2 bg-gray-200 hover:bg-gray-300 text-center border-r border-gray-400'>
                        <i class='fas fa-map-marker-alt mr-2'></i>Maps
                    </a>
                    <a href='https://waze.com/ul?q=" . $this->card->location_coordinate . "&navigate=yes&zoom=17'
                        class='p-2 bg-gray-200 hover:bg-gray-300 text-center'>
                        <i class='fab fa-waze mr-2'></i>Waze
                    </a>
                </div>";
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>Where is it?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>The event will be hold at " . $this->card->location_name . ".</p>
                    " . $address . $direction . "
                </div>
            </div>";
        }
        if ($question_id == 3) {
            $schedule_table = '';
            foreach($this->card->schedule as $key => $schedule) {
                $schedule_table = $schedule_table . "<tr>
                    <td class='p-2 bg-white'>" . $schedule['data']['time'] . "</td>
                    <td class='p-2 bg-white'>" . $schedule['data']['activity'] . "</td>
                </tr>";
            }
            $answer = "<div class='pl-8 pb-2'>
                <div class='p-2 bg-cyan-100 rounded-lg max-w-fit ml-auto shadow'>
                    <p>What's the schedule?</p>
                </div>
            </div>
            <div class='pr-8 pb-2'>
                <div class='p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow'>
                    <p>The schedule for the event is as below:</p>
                    <br>
                    <div class='overflow-hidden rounded-lg'>
                        <table class='table w-full'>
                            <thead>
                                <tr>
                                    <th class='p-2 bg-gray-200'><b>Time</b></th>
                                    <th class='p-2 bg-gray-200'><b>Activity</b></th>
                                </tr>
                            </thead>
                            <tbody>
                                " . $schedule_table . "
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>";
        }

        $this->reply = $this->reply . $answer;
    }

    public function render()
    {
        return view('livewire.chatbot.show-generic-card-modal');
    }
}
