<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attendee extends Model
{
    use HasFactory;

    protected $table = 'attendees';

    // Fillable based on the migration
    protected $fillable = [
        'user_id',
        'card_id',
        'generic_card_id',
        'name',
        'people_no',
        'phone_no',
        'timeslots',
        'time_arrival',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function card()
    {
        return $this->belongsTo(Card::class);
    }
}
