<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Card extends Model
{
    use HasFactory, softDeletes;

    protected $table = 'cards';

    // Fillable based on the migration
    protected $fillable = [
        'user_id',
        'theme_code',
        'custom_design',
        'title',
        'male_short_name',
        'male_full_name',
        'female_short_name',
        'female_full_name',
        'date_masihi',
        'date_hijrah',
        'time_start',
        'time_end',
        'location_name',
        'location_address',
        'location_map_url',
        'father_name',
        'mother_name',
        'program_name_1',
        'program_time_1',
        'program_name_2',
        'program_time_2',
        'program_name_3',
        'program_time_3',
        'contact_name_1',
        'contact_phone_1',
        'contact_name_2',
        'contact_phone_2',
        'image_1',
        'image_2',
        'image_3',
        'youtube_url',
        'money_gift_bank_name',
        'money_gift_bank_account_no',
        'money_gift_qr_code_image',
        'rsvp_timeslots',
        'side',
        'father_name_2',
        'mother_name_2',
        'bg_music',
    ];

    protected $casts = [
        'rsvp_timeslots' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function theme()
    {
        return $this->belongsTo(Theme::class, 'theme_code', 'code');
    }

    public function brideAndGroom()
    {
        return $this->male_short_name . ' & ' . $this->female_short_name;
    }

    public function attendees()
    {
        return $this->hasMany(Attendee::class);
    }

    public function isOldFormatRSVP()
    {
        $expectedKeys = ['timeslot_1', 'timeslot_2', 'timeslot_3', 'timeslot_4', 'timeslot_5', 'timeslot_6', 'timeslot_7', 'timeslot_8'];
        if ($this->rsvp_timeslots == null) {
            return false;
        }
        $rsvpKeys = array_keys($this->rsvp_timeslots);

        if (array_slice($rsvpKeys, 0, 8) == $expectedKeys) {
            return true;
        }

        return false;
    }

}
