<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CardPrintService extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'card_print_services';

    // Fillable based on the migration
    protected $fillable = [
        'vendor_id',
        'name',
        'description',
        'options',
    ];

    protected $casts = [
        'options' => 'array',
    ];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

}
