<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ComboCard extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'combo_cards';

    protected $fillable = [
        'user_id',
        'title',
        'description',
        'card_ids',
    ];

    protected $casts = [
        'card_ids' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'id', 'user_id');
    }

    // Based on the card_ids, get the cards as a collection

    public function cards()
    {
        return Card::whereIn('id', $this->card_ids)->get();
    }
}
