<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GenericCard extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'theme_code',
        'title',
        'subtitle',
        'date',
        'body',
        'start_time',
        'end_time',
        'location_name',
        'location_address',
        'location_coordinate',
        'schedule',
        'rsvp_timeslots',
        'bg_music',
    ];

    protected $casts = [
        'schedule' => 'array',
        'rsvp_timeslots' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function theme()
    {
        return $this->belongsTo(Theme::class, 'theme_code', 'code');
    }

    public function attendees()
    {
        return $this->hasMany(Attendee::class);
    }
}
