<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'vendors';

    // Fillable based on the migration
    protected $fillable = [
        'user_id',
        'name',
        'slug',
        'logo_image',
        'cover_image',
        'email',
        'phone_no',
        'whatsapp_no',
        'address',
        'state',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function cardPrintServices()
    {
        return $this->hasOne(CardPrintService::class);
    }

}
