<?php

namespace App\Providers\Filament;

use App\Filament\Pages\Dashboard;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Navigation\NavigationGroup;
use Filament\Navigation\NavigationItem;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use App\Filament\App\Resources\CardResource\Widgets\CardOverview;
use Filament\Navigation\MenuItem;


class AppPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('app')
            ->path('app')
            ->colors([
                'primary' => '#2dc8ff',
            ])
            ->navigationGroups([
                NavigationGroup::make()
                    ->label('My Folder'),
                NavigationGroup::make()
                    ->label('Links'),
                NavigationGroup::make()
                    ->label('Settings'),
            ])
            ->navigationItems([
                NavigationItem::make('Dashboard')
                    ->url(url('/app'), shouldOpenInNewTab: false)
                    ->icon('heroicon-o-square-3-stack-3d')
                    ->isActiveWhen(fn() => url()->current() === url('/app')),
                NavigationItem::make('Home')
                    ->url(url('/'), shouldOpenInNewTab: false)
                    ->icon('heroicon-o-home')
                    ->group('Links'),
                NavigationItem::make('Themes')
                    ->url(url('/themes'), shouldOpenInNewTab: false)
                    ->icon('heroicon-o-swatch')
                    ->group('Links'),
                NavigationItem::make('Contact')
                    ->url(url('/contact'), shouldOpenInNewTab: false)
                    ->icon('heroicon-o-phone')
                    ->group('Links'),
                NavigationItem::make('About')
                    ->url(url('/about'), shouldOpenInNewTab: false)
                    ->icon('heroicon-o-information-circle')
                    ->group('Links'),
                NavigationItem::make('Profile')
                    ->url(url('/profile'), shouldOpenInNewTab: false)
                    ->icon('heroicon-o-user-circle')
                    ->group('Settings'),
            ])
            ->userMenuItems([
                'profile' => MenuItem::make()
                    ->label('Profile')
                    ->icon('heroicon-o-user-circle')
                    ->url(url('/profile')),
            ])
            ->discoverResources(in: app_path('Filament/App/Resources'), for: 'App\\Filament\\App\\Resources')
            ->discoverPages(in: app_path('Filament/App/Pages'), for: 'App\\Filament\\App\\Pages')
            ->pages([
                    // Pages\Dashboard::class,
                Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/App/Widgets'), for: 'App\\Filament\\App\\Widgets')
            ->widgets([
                // CardOverview::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ])
            ->font('Outfit')
            ->darkMode(false)
            ->viteTheme('resources/css/filament/app/theme.css');
    }
}
