<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cards', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('user_id');
            $table->string('theme_code', 128);
            $table->string('title', 512)->nullable();
            $table->string('male_short_name', 128);
            $table->string('male_full_name', 512);
            $table->string('female_short_name', 128);
            $table->string('female_full_name', 512);
            $table->date('date_masihi');
            $table->string('date_hijrah', 128)->nullable();
            $table->string('time_start', 128)->nullable();
            $table->string('time_end', 128)->nullable();
            $table->string('location_name', 512)->nullable();
            $table->text('location_address')->nullable();
            $table->text('location_map_url')->nullable();
            $table->string('father_name', 512)->nullable();
            $table->string('mother_name', 512)->nullable();
            $table->string('program_name_1', 128)->nullable();
            $table->string('program_time_1', 128)->nullable();
            $table->string('program_name_2', 128)->nullable();
            $table->string('program_time_2', 128)->nullable();
            $table->string('program_name_3', 128)->nullable();
            $table->string('program_time_3', 128)->nullable();
            $table->string('contact_name_1', 128)->nullable();
            $table->string('contact_phone_1', 128)->nullable();
            $table->string('contact_name_2', 128)->nullable();
            $table->string('contact_phone_2', 128)->nullable();
            $table->text('image_1')->nullable();
            $table->text('image_2')->nullable();
            $table->text('image_3')->nullable();
            $table->text('youtube_url')->nullable();
            $table->text('zoom_url')->nullable();
            $table->longText('rsvp_timeslots')->nullable();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cards');
    }
};
