<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('logo_image')->nullable()->default(null);
            $table->text('cover_image')->nullable()->default(null);
            $table->string('email')->nullable()->default(null);
            $table->string('phone_no')->nullable()->default(null);
            $table->string('whatsapp_no')->nullable()->default(null);
            $table->text('address')->nullable()->default(null);
            $table->string('state')->nullable()->default(null);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendors');
    }
};
