<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('generic_cards', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('theme_code');
            $table->string('title');
            $table->string('subtitle')->nullable();
            $table->date('date');
            $table->text('body')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->string('location_name');
            $table->text('location_address')->nullable();
            $table->string('location_coordinate')->nullable();
            $table->text('schedule')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('generic_cards');
    }
};
