<x-app-layout>

    {{-- <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Login') }}
        </h2>
    </x-slot> --}}

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Session Status -->
            <x-auth-session-status class="mb-4" :status="session('status')" />

            <div class="px-4 flex flex-col lg:flex-row justify-center items-center gap-4 mb-8">
                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo"
                    class="w-20 h-20 lg:w-12 lg:h-12 rounded-full object-contain shadow border-2 border-primary">
                <p class="text-center">Guna akaun sosial media anda untuk login di KadKahwinDigital dengan mudah.</p>
            </div>

            @if (isset($error))
                <div class="mb-4 text-red-600 dark:text-red-400">
                    {{ $error }}
                </div>
            @endif

            <form method="POST" action="{{ route('login') }}"
                class="p-4 sm:p-8 bg-white dark:bg-gray-800 shadow sm:rounded-lg max-w-screen-sm mx-auto"
                x-data="{ showLoginEmail: false }">
                @csrf

                <div class="grid grid-cols-3 w-full gap-3">
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'facebook') }}'">
                        <div class="flex gap-2 flex-col lg:flex-row items-center justify-center">
                            <i class="fab fa-facebook fa-2x"></i>Facebook
                        </div>
                    </x-secondary-button>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'twitter') }}'">
                        <div class="flex gap-2 flex-col lg:flex-row items-center justify-center">
                            <i class="fab fa-twitter fa-2x"></i>Twitter/X
                        </div>
                    </x-secondary-button>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'google') }}'">
                        <div class="flex gap-2 flex-col lg:flex-row items-center justify-center">
                            <i class="fab fa-google fa-2x"></i>Google
                        </div>
                    </x-secondary-button>
                </div>

                @if (env('APP_DEBUG'))
                    <p class="underline mt-6 text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800 text-center cursor-pointer"
                        @click="showLoginEmail = !showLoginEmail">
                        {{ __('Login with Email') }}
                    </p>
                @endif

                <div x-show="showLoginEmail" class="pt-6 border-t mt-6">
                    <!-- Email Address -->
                    <div>
                        <x-input-label for="email" :value="__('Email')" />
                        <x-text-input id="email" class="block mt-1 w-full" type="email" name="email"
                            :value="old('email')" required autofocus autocomplete="username" />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <!-- Password -->
                    <div class="mt-4">
                        <x-input-label for="password" :value="__('Password')" />

                        <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required
                            autocomplete="current-password" />

                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <!-- Remember Me -->
                    <div class="block mt-4">
                        <label for="remember_me" class="inline-flex items-center">
                            <input id="remember_me" type="checkbox"
                                class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800"
                                name="remember">
                            <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">{{ __('Remember me') }}</span>
                        </label>
                    </div>

                    <div class="flex items-center justify-end mt-4">
                        @if (Route::has('password.request'))
                            <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800"
                                href="{{ route('password.request') }}">
                                {{ __('Forgot your password?') }}
                            </a>
                        @endif

                        <x-primary-button class="ml-3">
                            {{ __('Log in') }}
                        </x-primary-button>
                    </div>
                </div>

            </form>

        </div>
    </div>

</x-app-layout>
