<x-app-layout>

    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Print Cards') }}
        </h2>
    </x-slot>

    <style type="text/css">
        @font-face {
            font-family: "Primary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_primary }}");
        }

        @font-face {
            font-family: "Secondary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_secondary }}");
        }

        #print-docs {
            font-family: Arial, Helvetica, sans-serif;
        }

        .design-page {
            color: {{ $card->theme->color }};
        }

        .design-text-primary {
            font-family: "Primary";
            text-transform: {{ $card->theme->style_primary }};
        }

        .design-text-secondary {
            font-family: "Secondary";
        }

        #print-docs h1 {
            font-size: 72px;
        }

        #print-docs h2 {
            font-size: 64px;
        }

        #print-docs h3 {
            font-size: 48px;
        }

        #print-docs h4 {
            font-size: 36px;
        }

        #print-docs h5 {
            font-size: 24px;
        }

        #print-docs p {
            font-size: 18px;
        }
    </style>

    <!-- QRCode -->
    <script src="{{ url('/js/qrcode.js') }}"></script>
    <!-- HTML2Canvas -->
    <script src="{{ url('/js/html2canvas.js') }}"></script>
    <!-- Dom To Image -->
    <script src="{{ url('/js/dom-to-image.min.js') }}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.5.3/jspdf.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/simplelightbox@2.14.2/dist/simple-lightbox.min.js"></script>

    <link href="https://cdn.jsdelivr.net/npm/simplelightbox@2.14.2/dist/simple-lightbox.min.css" rel="stylesheet">

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="overflow-hidden h-0 w-0" id="print-docs">
                <div class="aspect-[4/6] relative" style="width: 1080px" id="front-card">
                    @if($card->theme->code == 'custom' && isset($card->custom_design))
                        <div class="flex items-center justify-center w-full h-full">
                        <img src="{{ url('/storage/') }}/{{ $card->custom_design }}" class="w-full" />
                        </div>
                    @else
                        <img src="{{ url('/theme/' . $card->theme_code . '/bg_primary.jpg') }}" class="w-full">
                    @endif
                    @if($card->theme->code != 'custom')
                        <div class="absolute top-0 left-0 w-full h-full flex items-center justify-center"
                            style="padding: 274px 140px;">
                            <div
                                class="w-full h-full flex flex-col justify-center items-center design-text-secondary design-page">
                                <h3 class="mb-6">
                                    @if ($card->title != null)
                                        {{ $card->title }}
                                    @else
                                        WALIMATULURUS
                                    @endif
                                </h3>
                                <h1 class="design-text-primary">{{ $card->male_short_name }}</h1>
                                <h4>&amp;</h4>
                                <h1 class="design-text-primary">{{ $card->female_short_name }}</h1>
                                <h3 class="mt-6">{{ date('d/m/Y', strtotime($card->date_masihi)) }}</h3>
                                <h4 class="mb-6">{{ $card->date_hijrah }}</h4>
                                <h3 class="text-center max-w-xl">
                                    {{ $card->location_name }}
                                </h3>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="aspect-[4/6] bg-white p-20" style="width: 1080px" id="back-card">

                    <div class="h-full flex flex-col justify-center items-center">
                        <p>Assalamualaikum w.b.t</p>
                        <h4 class="design-text-primary">{{ $card->father_name }}</h4>
                        @if ($card->mother_name != '' && $card->mother_name != null && $card->father_name != '' && $card->father_name != null)
                            <h4>&amp;</h4>
                        @endif
                        <h4 class="design-text-primary">{{ $card->mother_name }}</h4>
                        <p class="my-6 text-center max-w-xl">
                            DENGAN SEGALA HORMATNYA MEMPERSILAKAN Y.B. / Y.BHG. TAN SRI / PUAN SRI / DATUK / DATO’/
                            DATIN / TUAN / PUAN / SAUDARA / SAUDARI KE MAJLIS PERKAHWINAN
                        </p>
                        <h4 class="design-text-primary">{{ $card->male_full_name }}</h4>
                        <h4>&amp;</h4>
                        <h4 class="design-text-primary">{{ $card->female_full_name }}</h4>
                        <div class="flex-grow"></div>
                        <div class="py-6 w-full max-w-xl">
                            @if ($card->location_name)
                                <p class="font-bold mb-1">TEMPAT:</p>
                                <div class="mb-6">
                                    <h5>{{ $card->location_name }}</h5>
                                    @if ($card->location_address != null)
                                        <p>{{ $card->location_address }}</p>
                                    @endif
                                </div>
                            @endif
                            <p class="font-bold mb-1">TARIKH:</p>
                            <h5 class="mb-6">{{ date('d/m/Y', strtotime($card->date_masihi)) }}</h5>
                            @if( isset($card->program_time_1) || isset($card->program_name_1) || isset($card->program_time_2) || isset($card->program_name_2) || isset($card->program_time_3) || isset($card->program_name_3))
                                <p class="font-bold mb-1">ATURCARA:</p>
                                <h5>
                                    <table class="table table-borderless mb-6">
                                        <tbody>
                                            <tr>
                                                <td class="text-right pb-3">{{ $card->program_time_1 }}</td>
                                                <td class="pl-6 pb-3">{{ $card->program_name_1 }}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-right pb-3">{{ $card->program_time_2 }}</td>
                                                <td class="pl-6 pb-3">{{ $card->program_name_2 }}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-right">{{ $card->program_time_3 }}</td>
                                                <td class="pl-6">{{ $card->program_name_3 }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </h5>
                            @endif
                            <p class="mb-6 text-justify">
                                "Ya Allah Yang Maha Mencipta, Jadikanlah majlis ini majlis yang mendapat
                                keberkatan dan keredhaanMu, kekalkanlah ikatan perkahwinan mereka
                                sepanjang hayat, tetapkanlah kasih sayang antara mereka selagi tidak
                                melebihi kasih padaMu."
                            </p>
                            <p class="">Aamin, Ya Rabbal A'lamin</p>
                        </div>
                        <div class="flex-grow"></div>
                        <div class="flex gap-6 w-full max-w-xl">
                            <div class="aspect-square w-40 h-40" id="kkd-qrcode"></div>
                            <div class="flex flex-col flex-grow">
                                <p>IMBAS KOD QR SEKARANG</p>
                                <h5 class="font-bold">Kad Kahwin Digital + Chat AI</h5>
                                <div class="flex-grow"></div>
                                <p>{{ $card->male_short_name }} & {{ $card->female_short_name }}</p>
                                <p>{{ route('cards.show', $card->id) }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- <div class="aspect-[6/4] bg-white p-20" style="height: 1080px" id="back-card">
                    <div class="grid grid-cols-2 h-full">
                        <div class="border-r h-full flex flex-col justify-center items-center pr-20">
                            <p>Assalamualaikum w.b.t</p>
                            <h4 class="design-text-primary">{{ $card->father_name }}</h4>
                            @if ($card->mother_name != '' && $card->mother_name != null && $card->father_name != '' && $card->father_name != null)
                                <h4>&amp;</h4>
                            @endif
                            <h4 class="design-text-primary">{{ $card->mother_name }}</h4>
                            <p class="my-6 text-center">
                                DENGAN SEGALA HORMATNYA MEMPERSILAKAN Y.B. / Y.BHG. TAN SRI / PUAN SRI / DATUK / DATO’/
                                DATIN / TUAN / PUAN / SAUDARA / SAUDARI KE MAJLIS PERKAHWINAN
                            </p>
                            <h4 class="design-text-primary">{{ $card->male_full_name }}</h4>
                            <h4>&amp;</h4>
                            <h4 class="design-text-primary">{{ $card->female_full_name }}</h4>
                            <div class="flex-grow"></div>
                            <div class="flex gap-6 w-full">
                                <div class="aspect-square w-40 h-40" id="kkd-qrcode"></div>
                                <div class="flex flex-col flex-grow">
                                    <p>IMBAS KOD QR SEKARANG</p>
                                    <h5 class="font-bold">Kad Kahwin Digital</h5>
                                    <p>{{ $card->male_short_name }} & {{ $card->female_short_name }}</p>
                                    <p>{{ route('cards.show', $card->id) }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="pl-20 flex flex-col justify-center items-start">
                            <p class="font-bold mb-3">TEMPAT</p>
                            <div class="mb-12">
                                <h5>{{ $card->location_name }}</h5>
                                @if ($card->location_address != null)
                                    <p>{{ $card->location_address }}</p>
                                @endif
                            </div>
                            <p class="font-bold mb-3">TARIKH</p>
                            <h5 class="mb-12">{{ date('d/m/Y', strtotime($card->date_masihi)) }}</h5>
                            <p class="font-bold mb-3">ATURCARA</p>
                            <h5>
                                <table class="table table-borderless mb-6">
                                    <tbody>
                                        <tr>
                                            <td class="text-right pb-3">{{ $card->program_time_1 }}</td>
                                            <td class="pl-6 pb-3">{{ $card->program_name_1 }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-right pb-3">{{ $card->program_time_2 }}</td>
                                            <td class="pl-6 pb-3">{{ $card->program_name_2 }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-right">{{ $card->program_time_3 }}</td>
                                            <td class="pl-6">{{ $card->program_name_3 }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </h5>
                            <div class="flex-grow"></div>
                            <p class="mb-6 text-justify">
                                "Ya Allah Yang Maha Mencipta, Jadikanlah majlis ini majlis yang mendapat
                                keberkatan dan keredhaanMu, kekalkanlah ikatan perkahwinan mereka
                                sepanjang hayat, tetapkanlah kasih sayang antara mereka selagi tidak
                                melebihi kasih padaMu."
                            </p>
                            <p class="">Aamin, Ya Rabbal A'lamin</p>
                        </div>
                    </div>
                </div> --}}
            </div>

            <div class="grid lg:grid-cols-1 gap-6 mb-12">
                {{-- <div class="mx-6 lg:mx-0">
                    <h1 class="text-lg font-bold text-gray-900 mb-6">
                        Cara Order Print Kad Kahwin
                    </h1>
                    <div class="grid grid-cols-1 gap-6">
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 rounded-full shadow bg-white flex items-center justify-center text-xl mr-3 aspect-[1/1]">
                                <i class="fas fa-envelope-open-text"></i>
                            </div>
                            <div class="flex flex-col">
                                <h1 class="font-bold text-gray-900">Semak</h1>
                                <p class="text-gray-900 text-sm">Semak maklumat di kad kahwin anda di bahagian
                                    preview.</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 rounded-full shadow bg-white flex items-center justify-center text-xl mr-3 aspect-[1/1]">
                                <i class="fas fa-user-edit"></i>
                            </div>
                            <div class="flex flex-col">
                                <h1 class="font-bold text-gray-900">Isi Borang Order</h1>
                                <p class="text-gray-900 text-sm">
                                    Isi maklumat anda di borang order dibawah.
                                </p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 rounded-full shadow bg-white flex items-center justify-center text-xl mr-3 aspect-[1/1]">
                                <i class="fas fa-shopping-basket"></i>
                            </div>
                            <div class="flex flex-col">
                                <h1 class="font-bold text-gray-900">Bayar</h1>
                                <p class="text-gray-900 text-sm">
                                    Buat bayaran secara online melalui FPX, Boost, GrabPay, TnG, PayPal atau bank.
                                </p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 rounded-full shadow bg-white flex items-center justify-center text-xl mr-3 aspect-[1/1]">
                                <i class="fas fa-store"></i>
                            </div>
                            <div class="flex flex-col">
                                <h1 class="font-bold text-gray-900">Pilih Kedai</h1>
                                <p class="text-gray-900 text-sm">
                                    Pilih kedai yang anda mahu untuk cetak kad kahwin anda.
                                </p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 rounded-full shadow bg-white flex items-center justify-center text-xl mr-3 aspect-[1/1]">
                                <i class="fab fa-whatsapp"></i>
                            </div>
                            <div class="flex flex-col">
                                <h1 class="font-bold text-gray-900">WhatsApp</h1>
                                <p class="text-gray-900 text-sm">
                                    Hantar maklumat kad kahwin anda kepada kedai yang anda pilih melalui WhatsApp.
                                </p>
                            </div>
                        </div>
                    </div>
                </div> --}}
                <div class="mx-6 lg:mx-0">
                    <p class="text-sm mb-2 w-full text-center">Preview Kad Kahwin</p>
                    <div class="grid lg:grid-cols-2 gap-6 bg-white shadow rounded-lg p-6">
                        <div class="flex items-center justify-center">
                            <a href="#" class="w-full h-full venobox" id="preview-front-card-venobox">
                                <img id="preview-front-card" class="w-full my-auto shadow-lg border">
                            </a>
                        </div>
                        <div class="flex items-center justify-center relative">
                            <a href="#" class="w-full venobox" id="preview-back-card-venobox">
                                <img id="preview-back-card" class="w-full my-auto shadow-lg border">
                            </a>
                            {{-- <button onclick="download()"
                                class="absolute bottom-6 right-6 h-8 w-8 flex justify-center items-center rounded border-black border text-sm text-black font-bold bg-black bg-opacity-20 opacity-50 hover:opacity-70">
                                <i class="fas fa-save"></i>
                            </button> --}}
                        </div>
                    </div>
                    {{-- <p class="mt-2 text-xs text-gray-400">Peringatan: Urusan printing kad kahwin adalah diantara
                        pengguna & pihak kedai. Bukan dibawah bidang kuasa KKD.</p> --}}
                    <button onclick="download()"
                        class="h-12 px-3 flex mt-6 mx-auto justify-center items-center rounded border-black border text-sm text-black font-bold bg-black bg-opacity-20 opacity-50 hover:opacity-70">
                        <i class="fas fa-save mr-2"></i> Download PDF
                    </button>
                </div>

            </div>

            {{-- @auth
                @if (Auth::user()->id == $card->user_id)
                    <livewire:cards.print-checkout />
                @endif
            @endauth --}}

            {{-- <h1 class="text-lg font-bold text-gray-900 mb-3 mx-6 lg:mx-0">
                Pilihan Kedai Printing Kad Kahwin
            </h1>

            <livewire:vendors.listing /> --}}

        </div>
    </div>

    <script type="text/javascript">
        new QRCode(document.getElementById("kkd-qrcode"), {
            text: "{{ route('cards.show', $card->id) }}",
            width: 160,
            height: 160,
            colorDark: "#000000",
            colorLight: "#ffffff",
            correctLevel: QRCode.CorrectLevel.H
        });

        window.addEventListener("DOMContentLoaded", function() {
            new VenoBox({
                selector: ".venobox"
            });
        });

        window.onload = function() {
            domtoimage.toBlob(document.getElementById('front-card'))
                .then(function(blob) {
                    document.getElementById('preview-front-card').src = URL.createObjectURL(blob);
                    document.getElementById('preview-front-card-venobox').href = URL.createObjectURL(blob);
                });

            domtoimage.toBlob(document.getElementById('back-card'))
                .then(function(blob) {
                    document.getElementById('preview-back-card').src = URL.createObjectURL(blob);
                    document.getElementById('preview-back-card-venobox').href = URL.createObjectURL(blob);
                });
        }

        function download() {

            const filename = 'KadKahwinDigitalPrint.pdf';
            /* Render Front Card */
            domtoimage.toBlob(document.getElementById('front-card'))
                .then(function(blob) {
                    var reader = new FileReader();
                    reader.readAsDataURL(blob);
                    reader.onloadend = function() {
                        let imagedata = reader.result;
                        let pdf = new jsPDF('p', 'mm', 'a4');
                        pdf.addImage(reader.result, 'PNG', 0, 0, 210, 297);
                        /* Render Back Card */
                        domtoimage.toBlob(document.getElementById('back-card'))
                            .then(function(blob) {
                                var reader = new FileReader();
                                reader.readAsDataURL(blob);
                                reader.onloadend = function() {
                                    let imagedata = reader.result;
                                    pdf.addPage('a4', 'p').addImage(reader.result, 'PNG', 0, 0, 210, 297);
                                    pdf.save(filename);
                                }
                            });
                    }
                });

        }
    </script>

</x-app-layout>
