<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-LCBDTMKX5Q"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-LCBDTMKX5Q');
    </script>

    <!--Open Graph Metatag-->
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ $card->male_short_name }} & {{ $card->female_short_name }}" />
    <meta property="og:description" content="{{ $card->date_masihi }} | {{ $card->location_name }}">
    <meta property="og:image" content="{{ url('/images/kkd-preview.png') }}" />
    <meta property="og:image:width" content="256" />
    <meta property="og:image:height" content="256" />
    <meta property="og:url" content="{{ url()->current() }}" />

    <!-- Chrome, Firefox OS and Opera -->
    <meta name="theme-color" content="#2dc8ff">
    <!-- Windows Phone -->
    <meta name="msapplication-navbutton-color" content="#2dc8ff">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#2dc8ff">

    <title>{{ config('app.name', 'Kad Kahwin Digital') }}</title>

    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('/images/apple-touch-icon.png') }}">
    <link rel="shortcut icon" href="{{ url('/favicon.ico') }}" type="image/x-icon">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
        integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/venobox@2.0.4/dist/venobox.min.css" type="text/css"
        media="screen" />

    <style type="text/css">
        @font-face {
            font-family: "Primary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_primary }}");
        }

        @font-face {
            font-family: "Secondary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_secondary }}");
        }

        body {
            font-family: "Outfit";
            background-attachment: fixed;
        }

        .design-page {
            color: {{ $card->theme->color }};
        }

        .design-text-primary {
            font-family: "Primary";
            text-transform: {{ $card->theme->style_primary }};
        }

        .design-text-secondary {
            font-family: "Secondary";
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="//unpkg.com/alpinejs" defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.8.1/flowbite.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.3/dist/confetti.browser.min.js"></script>

    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2dc8ff',
                        prime: '#00aae6',
                    }
                }
            },
            darkMode: 'class',
        }
    </script>

    <script type="text/javascript">
        // Set the date we're counting down to
        var countDownDate = new Date("{{ $card->date_masihi }}").getTime();

        // Update the count down every 1 second
        var x = setInterval(function() {

            // Get today's date and time
            var now = new Date().getTime();

            // Find the distance between now and the count down date
            var distance = countDownDate - now;

            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element
            document.getElementById("text_days").innerHTML = days;
            document.getElementById("text_hours").innerHTML = hours;
            document.getElementById("text_seconds").innerHTML = seconds;
            document.getElementById("text_seconds").innerHTML = seconds;

            // If the count down is over, write some text
            if (distance < 0) {
                clearInterval(x);
                document.getElementById("countdown-block").setAttribute("class", "text-center");
                document.getElementById("countdown-block").innerHTML = "MAJLIS TELAH BERLANGSUNG";
            }
        }, 1000);


        function open_envelope() {
            var envelope = document.getElementById("envelope-body");
            var top = document.getElementById("envelope-top");
            var bottom = document.getElementById("envelope-bottom");

            top.setAttribute("data-aos", "slide-down");
            top.setAttribute("data-aos-duration", "1000");
            bottom.setAttribute("data-aos", "slide-up");
            bottom.setAttribute("data-aos-duration", "1000");

            setTimeout(function() {
                envelope.remove();
                confetti({
                    particleCount: 100,
                    spread: 70,
                    origin: { y: 0.6 }
                });
            }, 800);
        }
    </script>

    @livewireStyles

    <!-- Matomo -->
    <script>
        var _paq = window._paq = window._paq || [];
        /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
        _paq.push(['trackPageView']);
        _paq.push(['enableLinkTracking']);
        (function() {
            var u = "//analytics.bookklik.com/";
            _paq.push(['setTrackerUrl', u + 'matomo.php']);
            _paq.push(['setSiteId', '2']);
            var d = document,
                g = d.createElement('script'),
                s = d.getElementsByTagName('script')[0];
            g.async = true;
            g.src = u + 'matomo.js';
            s.parentNode.insertBefore(g, s);
        })();
    </script>
    <!-- End Matomo Code -->

</head>

<body class="bg-gray-200">

    <div id="envelope-body" class="fixed h-screen w-screen top-0 left-0 overflow-hidden z-20 flex flex-col">
        <div id="envelope-top" class="h-[50%] w-full bg-slate-800 p-8 bg-opacity-90 backdrop-blur-xl border-b-0 border-primary"></div>
        <div id="envelope-bottom" class="h-[50%] w-full bg-slate-800 p-8 bg-opacity-90 backdrop-blur-xl relative flex items-center justify-center border-t-0 border-primary">
            <div class="flex flex-col items-center absolute w-24 h-24 -top-12 bg-white rounded-full" onclick="open_envelope()">
                <span class="animate-ping duration-1000 absolute top-0 left-0 inline-flex h-full w-full rounded-full bg-sky-400 opacity-75"></span>
                <div class="text-white p-2 absolute -top-8 w-48 text-center uppercase text-xs font-bold tracking-wide">
                    Selamat Datang
                </div>
                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo" class="w-full h-full object-contain rounded-full border-4 border-primary hover:scale-110 duration-300 cursor-pointer z-10">
                <div class="text-white p-2 absolute -bottom-8 w-48 text-center uppercase text-xs font-bold tracking-wide">
                    Tekan Untuk Buka
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center justify-center shadow-lg border-b border-gray-200 design-text-secondary design-page lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        @if($card->theme->code == 'custom' && isset($card->custom_design))
            <img src="{{ url('/storage/') }}/{{ $card->custom_design }}" class="w-full" />
        @else
            <img src="{{ url('/theme') }}/{{ $card->theme->code }}/bg_primary.jpg" class="w-full" />
        @endif
        @if($card->theme->code != 'custom')
            <div class="flex flex-col items-center absolute max-w-xs w-full px-7">
                <p class="mb-6 text-center">
                    @if ($card->title != null)
                        {{ $card->title }}
                    @else
                        WALIMATULURUS
                    @endif
                </p>

                <h1 class="text-4xl design-text-primary">
                    @if ($card->side)
                        {{ $card->female_short_name }}
                    @else
                        {{ $card->male_short_name }}
                    @endif
                </h1>
                <p>&</p>
                <h1 class="text-4xl design-text-primary">
                    @if ($card->side)
                        {{ $card->male_short_name }}
                    @else
                        {{ $card->female_short_name }}
                    @endif
                </h1>
                <h3 class="mt-6 text-xl">{{ $card->date_masihi }}</h3>
                <h4 class="mb-6">{{ $card->date_hijrah }}</h4>
                <h3 class="text-xl text-center">
                    {{ $card->location_name }}
                </h3>
            </div>
        @endif
    </div>

    @if ($card->bg_music != null && $card->bg_music != '')
        <audio controls autoplay class="mx-auto w-full max-w-sm" data-aos="zoom-in-up" data-aos-duration="1000">
            <source src="{{ url('storage/' . $card->bg_music) }}" type="audio/mpeg">
        </audio>
    @endif

    <livewire:cards.advertisment-section />

    <div class="max-w-sm mx-auto bg-white w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <p class="mb-6">Assalamualaikum w.b.t</p>

        @if ($card->side)
            {{-- START::PIHAK PEREMPUAN --}}

            {{-- IBU BAPA PEREMPUAN --}}
            @if ($card->father_name_2 != '' && $card->father_name_2 != null)
                <h2 class="text-xl design-text-primary">{{ $card->father_name_2 }}</h2>
            @endif
            @if (
                $card->mother_name_2 != '' &&
                    $card->mother_name_2 != null &&
                    $card->father_name_2 != '' &&
                    $card->father_name_2 != null)
                <p>&amp;</p>
            @endif
            @if ($card->mother_name_2 != '' && $card->mother_name_2 != null)
                <h2 class="text-xl design-text-primary">{{ $card->mother_name_2 }}</h2>
            @endif

            {{-- TOGETHER WITH --}}
            @if ($card->mother_name != '' && $card->mother_name != null && $card->father_name != '' && $card->father_name != null)
                <div class="w-full h-8 flex items-center justify-center">Bersama-sama Dengan</div>
            @endif

            {{-- IBU BAPA LELAKI --}}
            @if ($card->father_name != '' && $card->father_name != null)
                <h2 class="text-xl design-text-primary">{{ $card->father_name }}</h2>
            @endif
            @if ($card->mother_name != '' && $card->mother_name != null && $card->father_name != '' && $card->father_name != null)
                <p>&amp;</p>
            @endif
            @if ($card->mother_name != '' && $card->mother_name != null)
                <h2 class="text-xl design-text-primary">{{ $card->mother_name }}</h2>
            @endif

            {{-- END::PIHAK PEREMPUAN --}}
        @else
            {{-- START::PIHAK LELAKI --}}

            {{-- IBU BAPA LELAKI --}}
            @if ($card->father_name != '' && $card->father_name != null)
                <h2 class="text-xl design-text-primary">{{ $card->father_name }}</h2>
            @endif
            @if ($card->mother_name != '' && $card->mother_name != null && $card->father_name != '' && $card->father_name != null)
                <p>&amp;</p>
            @endif
            @if ($card->mother_name != '' && $card->mother_name != null)
                <h2 class="text-xl design-text-primary">{{ $card->mother_name }}</h2>
            @endif

            {{-- TOGETHER WITH --}}
            @if (
                $card->mother_name_2 != '' &&
                    $card->mother_name_2 != null &&
                    $card->father_name_2 != '' &&
                    $card->father_name_2 != null)
                <div class="w-full h-8 flex items-center justify-center">Bersama-sama Dengan</div>
            @endif

            {{-- IBU BAPA PEREMPUAN --}}
            @if ($card->father_name_2 != '' && $card->father_name_2 != null)
                <h2 class="text-xl design-text-primary">{{ $card->father_name_2 }}</h2>
            @endif
            @if (
                $card->mother_name_2 != '' &&
                    $card->mother_name_2 != null &&
                    $card->father_name_2 != '' &&
                    $card->father_name_2 != null)
                <p>&amp;</p>
            @endif
            @if ($card->mother_name_2 != '' && $card->mother_name_2 != null)
                <h2 class="text-xl design-text-primary">{{ $card->mother_name_2 }}</h2>
            @endif

            {{-- END::PIHAK LELAKI --}}
        @endif


        <p class="my-4 text-sm">
            DENGAN SEGALA HORMATNYA MEMPERSILAKAN Y.B. / Y.BHG. TAN SRI / PUAN SRI /
            DATUK / DATO’/ DATIN / TUAN / PUAN / SAUDARA / SAUDARI KE MAJLIS
            {{ $card->id == 13980 ? 'KESYUKURAN' : 'PERKAHWINAN' }}
        </p>
        <h2 class="text-xl design-text-primary">{{ $card->male_full_name }}</h2>
        <p>&amp;</p>
        <h2 class="text-xl design-text-primary">{{ $card->female_full_name }}</h2>
        <div class="mt-12 flex flex-col">
            <h6 class="font-bold">TEMPAT</h6>
            <p class="mb-4">
                {{ $card->location_address ?? 'Maklumat tidak lengkap' }}
            </p>
            <h6 class="font-bold">TARIKH</h6>
            <p class="mb-4">{{ date('d M Y', strtotime($card->date_masihi)) }}</p>
            <h6 class="font-bold">MASA</h6>
            <p class="mb-4">{{ $card->time_start }} - {{ $card->time_end }}</p>
        </div>
        @if ($card->rsvp_timeslots != null)
            <div class="pt-12">
                <button id="btn_rsvp"
                    class="px-4 py-3 bg-prime hover:bg-primary rounded-full w-full text-center text-white border border-2 border-gray-900">
                    <i class="fas fa-calendar-check mr-2"></i>Saya Akan Hadir<span
                        class="bg-white text-prime text-sm px-2 py-1 ml-2 rounded-full">RSVP</span>
                </button>
            </div>
        @endif
    </div>

    @if( isset($card->program_time_1) || isset($card->program_name_1) || isset($card->program_time_2) || isset($card->program_name_2) || isset($card->program_time_3) || isset($card->program_name_3))
        <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center justify-center shadow-lg border-b border-gray-200 design-text-secondary design-page lg:rounded-xl lg:overflow-hidden lg:my-3"
            data-aos="zoom-in-up" data-aos-duration="1000">
            <img src="{{ url('/theme') }}/{{ $card->theme->code }}/bg_secondary.jpg" class="w-full" />
            <div class="flex flex-col items-center absolute max-w-xs w-full px-6">
                <h2 class="text-xl mb-12">ATURCARA</h2>
                <table class="table table-borderless"
                    style="color: {{ $card->theme->color }}; width: fit-content ;margin: 0 auto;">
                    <tbody>
                        <tr>
                            <td class="text-right pb-8">{{ $card->program_time_1 }}</td>
                            <td class="pl-8 pb-8">{{ $card->program_name_1 }}</td>
                        </tr>
                        <tr>
                            <td class="text-right pb-8">{{ $card->program_time_2 }}</td>
                            <td class="pl-8 pb-8">{{ $card->program_name_2 }}</td>
                        </tr>
                        <tr>
                            <td class="text-right">{{ $card->program_time_3 }}</td>
                            <td class="pl-8">{{ $card->program_name_3 }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    @endif

    <livewire:cards.advertisment-section />

    <div class="max-w-sm mx-auto bg-white w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <p class="text-sm mb-6">
            "Ya Allah Yang Maha Mencipta, Jadikanlah majlis ini majlis yang mendapat
            keberkatan dan keredhaanMu, kekalkanlah ikatan perkahwinan mereka
            sepanjang hayat, tetapkanlah kasih sayang antara mereka selagi tidak
            melebihi kasih padaMu."
        </p>
        <p class="text-sm">Aamin, Ya Rabbal A'lamin</p>
    </div>

    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <h2 class="text-xl mb-12">COUNTDOWN</h2>
        @php
            $count_date = explode('-', $card->date_masihi);
        @endphp
        <div class="grid grid-cols-4 w-full" id="countdown-block">
            <big><span id="text_days">0</span></big>
            <big><span id="text_hours">0</span></big>
            <big><span id="text_minutes">0</span></big>
            <big><span id="text_seconds">0</span></big>
            <span><small>Hari</small></span>
            <span><small>Jam</small></span>
            <span><small>Minit</small></span>
            <span><small>Saat</small></span>
        </div>
    </div>

    @if (isset($card->image_1) || isset($card->image_2) || isset($card->image_3))
        <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white lg:rounded-xl lg:overflow-hidden lg:my-3"
            data-aos="zoom-in-up" data-aos-duration="1000">
            <h2 class="text-xl mb-12">GALLERY</h2>

            <div class="w-full mx-auto">

                <div id="default-carousel" class="relative" data-carousel="static">
                    <!-- Carousel wrapper -->
                    <div class="overflow-hidden relative h-56 rounded-lg sm:h-64 xl:h-80 2xl:h-96">
                        <!-- Item 1 -->
                        @if (isset($card->image_1))
                            <a href="{{ url('/storage/') }}/{{ $card->image_1 }}"
                                class="hidden duration-700 ease-in-out bg-gray-300 venobox" data-carousel-item>
                                <img src="{{ url('/storage/') }}/{{ $card->image_1 }}"
                                    class="block absolute top-1/2 left-1/2 w-full -translate-x-1/2 -translate-y-1/2">
                            </a>
                        @else
                            <div class="w-full h-full bg-gray-300 flex items-center justify-center" data-carousel-item>
                                <img src="{{ url('/images/navbar_brand.svg') }}" class="w-full h-12" />
                            </div>
                        @endif
                        <!-- Item 2 -->
                        @if (isset($card->image_2))
                            <a href="{{ url('/storage/') }}/{{ $card->image_2 }}"
                                class="hidden duration-700 ease-in-out bg-gray-300 venobox" data-carousel-item>
                                <img src="{{ url('/storage/') }}/{{ $card->image_2 }}"
                                    class="block absolute top-1/2 left-1/2 w-full -translate-x-1/2 -translate-y-1/2">
                            </a>
                        @else
                            <div class="w-full h-full bg-gray-300 flex items-center justify-center" data-carousel-item>
                                <img src="{{ url('/images/navbar_brand.svg') }}" class="w-full h-12" />
                            </div>
                        @endif
                        <!-- Item 3 -->
                        @if (isset($card->image_3))
                            <a href="{{ url('/storage/') }}/{{ $card->image_3 }}"
                                class="hidden duration-700 ease-in-out bg-gray-300 venobox" data-carousel-item>
                                <img src="{{ url('/storage/') }}/{{ $card->image_3 }}"
                                    class="block absolute top-1/2 left-1/2 w-full -translate-x-1/2 -translate-y-1/2">
                            </a>
                        @else
                            <div class="w-full h-full bg-gray-300 flex items-center justify-center" data-carousel-item>
                                <img src="{{ url('/images/navbar_brand.svg') }}" class="w-full h-12" />
                            </div>
                        @endif
                    </div>
                    <!-- Slider indicators -->
                    <div class="flex absolute bottom-5 left-1/2 z-30 space-x-3 -translate-x-1/2">
                        <button type="button" class="w-3 h-3 rounded-full" aria-current="false"
                            aria-label="Slide 1" data-carousel-slide-to="0"></button>
                        <button type="button" class="w-3 h-3 rounded-full" aria-current="false"
                            aria-label="Slide 2" data-carousel-slide-to="1"></button>
                        <button type="button" class="w-3 h-3 rounded-full" aria-current="false"
                            aria-label="Slide 3" data-carousel-slide-to="2"></button>
                    </div>
                    <!-- Slider controls -->
                    <button type="button"
                        class="flex absolute top-0 left-0 z-30 justify-center items-center px-4 h-full cursor-pointer group focus:outline-none"
                        data-carousel-prev>
                        <span
                            class="inline-flex justify-center items-center w-8 h-8 rounded-full sm:w-10 sm:h-10 bg-white/30 dark:bg-gray-800/30 group-hover:bg-white/50 dark:group-hover:bg-gray-800/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                            <svg class="w-5 h-5 text-white sm:w-6 sm:h-6 dark:text-gray-800" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 19l-7-7 7-7"></path>
                            </svg>
                            <span class="hidden">Previous</span>
                        </span>
                    </button>
                    <button type="button"
                        class="flex absolute top-0 right-0 z-30 justify-center items-center px-4 h-full cursor-pointer group focus:outline-none"
                        data-carousel-next>
                        <span
                            class="inline-flex justify-center items-center w-8 h-8 rounded-full sm:w-10 sm:h-10 bg-white/30 dark:bg-gray-800/30 group-hover:bg-white/50 dark:group-hover:bg-gray-800/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                            <svg class="w-5 h-5 text-white sm:w-6 sm:h-6 dark:text-gray-800" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                            <span class="hidden">Next</span>
                        </span>
                    </button>
                </div>
            </div>

        </div>
    @endif

    @if ($card->youtube_url != null || $card->youtube_url != '')
        <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white lg:rounded-xl lg:overflow-hidden lg:my-3"
            data-aos="zoom-in-up" data-aos-duration="1000">
            <h2 class="text-xl mb-12">VIDEO LAGU</h2>
            @php
                $video_autoplay = $card->bg_music != null && $card->bg_music != '' ? 'autoplay;' : null;
            @endphp
            <iframe class="w-full aspect-video rounded-lg overflow-hidden" src="{{ $card->youtube_url }}?autoplay=1"
                frameborder="0"
                allow="accelerometer; {{ $video_autoplay }} encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen></iframe>
        </div>
    @endif

    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 bg-white lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <p class="mb-2 text-xs font-bold">POWERED BY</p>
        <a href="{{ url('/') }}">
            <img src="{{ url('/images/navbar_brand.svg') }}" class="w-full h-12" />
        </a>
        <p class="my-4">Follow Us</p>
        <div class="grid grid-cols-3 text-4xl gap-8">
            <a href="https://www.facebook.com/kadkahwindigital" target="_blank">
                <i class="fab fa-facebook"></i>
            </a>
            <a href="https://twitter.com/kaddigital" target="_blank">
                <i class="fab fa-twitter"></i>
            </a>
            <a href="https://www.instagram.com/kadkahwindigital.my/" target="_blank">
                <i class="fab fa-instagram"></i>
            </a>
        </div>
    </div>

    <div class="w-full h-16"></div>

    <div class="fixed w-full bg-gray-900 z-10 bottom-0">
        <div class="h-16 max-w-sm mx-auto grid grid-cols-5 text-white">
            <div id="btn_calendar"
                class="flex items-center justify-center flex-col hover:bg-black cursor-pointer grow">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <p class="text-xs">Calendar</p>
            </div>
            <div id="btn_location"
                class="flex items-center justify-center flex-col hover:bg-black cursor-pointer grow">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-map-marked-alt"></i>
                </div>
                <p class="text-xs">Location</p>
            </div>
            <div id="btn_chatbot" class="flex items-center justify-center flex-col cursor-pointer grow relative">
                <div class="w-full absolute -top-6 left-0 flex justify-center">
                    <div
                        class="flex items-center justify-center w-12 h-12 bg-prime hover:bg-primary rounded-full border-2 border-gray-900 overflow-hidden">
                        <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-cover" />
                    </div>
                </div>
                <div class="mb-2 w-4 h-4 text-white"></div>
                <p class="text-xs text-primary font-bold">Chat AI</p>
            </div>
            <div id="btn_money_gift"
                class="flex items-center justify-center flex-col hover:bg-black cursor-pointer grow">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-hand-holding-usd"></i>
                </div>
                <p class="text-xs">Money Gift</p>
            </div>
            <div id="btn_contacts"
                class="flex items-center justify-center flex-col hover:bg-black cursor-pointer grow">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-phone"></i>
                </div>
                <p class="text-xs">Contacts</p>
            </div>
        </div>
    </div>

    <div
        class="hidden fixed kkd-backdrop w-full h-full bg-gray-800 bg-opacity-90 top-0 z-20 flex flex-col justify-end px-4">

        <div id="modal_rsvp"
            class="max-w-sm w-full rounded-2xl bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden overflow-hidden">
            <livewire:cards.attendance-modal :card="$card" />
        </div>

        <div id="modal_calendar"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            <h1 class="text-3xl font-bold">{{ date('d/m/Y', strtotime($card->date_masihi)) }}</h1>
            <h6 class="mb-4">{{ $card->time_start }} - {{ $card->time_end }}</h6>
            @php
                $event_date = str_replace('-', '', $card->date_masihi);
                $event_start = str_replace(':', '', $card->time_start);
                $event_end = str_replace(':', '', $card->time_end);
            @endphp
            <button id="btn-add-to-calendar" type="button"
                class="p-4 bg-gray-200 hover:bg-gray-300 rounded-lg w-full text-center"
                onclick="window.open('https://calendar.google.com/calendar/r/eventedit?text={{ $card->male_full_name }}+%26+{{ $card->female_full_name }}&dates={{ $event_date }}T{{ $event_start }}00%2F{{ $event_date }}T{{ $event_end }}00&details={{ $card->male_full_name }}+%26+{{ $card->female_full_name }}%0A%0AAlamat+%3A2%2C+{{ $card->location_address }}&location={{ $card->location_name }}&sf=true&output=xml', '_blank')">
                <i class="fas fa-calendar-plus mr-2"></i>Add to Calendar
            </button>
        </div>

        <div id="modal_location"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            @if ($card->location_map_url != null && $card->location_map_url != '')
                <h6 class="mb-4 text-xl text-center">{{ $card->location_name }}</h6>
                <div class="grid grid-cols-2 w-full">
                    <a href="https://maps.google.com/maps?daddr={{ $card->location_map_url }}&navigate=yes"
                        class="p-4 bg-gray-200 hover:bg-gray-300 rounded-l-lg w-full text-center">
                        <i class="fas fa-map-marker-alt mr-2"></i>Maps
                    </a>
                    <a href="https://waze.com/ul?q={{ $card->location_map_url }}&navigate=yes&zoom=17"
                        class="p-4 bg-gray-200 hover:bg-gray-300 rounded-r-lg w-full text-center">
                        <i class="fab fa-waze mr-2"></i>Waze
                    </a>
                </div>
            @else
                <p class="text-sm">Maklumat tidak lengkap</p>
            @endif
        </div>

        <div id="modal_chatbot"
            class="max-w-sm w-full rounded-2xl bg-white mx-auto mb-8 shadow-lg flex flex-col items-center overflow-hidden hidden">
            <livewire:chatbot.show-card-modal :card="$card" />
        </div>

        <div id="modal_money_gift"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            @if (
                $card->money_gift_bank_name != null &&
                    $card->money_gift_bank_account_no != null &&
                    $card->money_gift_qr_code_image != null)
                <p class="text-sm mb-2 font-semibold">Bank Account</p>
                <h6 class="mb-4 p-2 bg-gray-100 w-full rounded-lg text-center">{{ $card->money_gift_bank_name }}</h6>
                <p class="text-sm mb-2 font-semibold">No Account</p>
                <h6 class="mb-4 p-2 bg-gray-100 w-full rounded-lg text-center">
                    {{ $card->money_gift_bank_account_no }}<button type="button" class="copy"
                        data-clipboard-text="{{ $card->money_gift_bank_account_no }}"><i
                            class="far fa-clone ml-2"></i></button>
                </h6>
                <p class="text-sm mb-2 font-semibold">Kod QR</p>
                <img src="{{ url('storage/' . $card->money_gift_qr_code_image) }}" class="w-32 h-32" />
                <a href="{{ url('storage/' . $card->money_gift_qr_code_image) }}" download="qr_code.png"
                    class="p-4 bg-gray-200 hover:bg-gray-300 rounded-lg w-full text-center mt-4">
                    <i class="fas fa-download mr-2"></i>Download
                </a>
            @else
                <p class="text-sm">Maklumat tidak lengkap</p>
            @endif
        </div>

        <div id="modal_contacts"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center space-y-4 hidden">
            @if ($card->contact_name_1 != null && $card->contact_phone_1 != null)
                <div class="flex items-center w-full">
                    <p class="flex-grow text-xl">
                        <i class="fas fa-user-circle mr-2"></i>{{ $card->contact_name_1 }}
                    </p>
                    <div class="grid grid-cols-2 text-xl">
                        <a href="tel:{{ $card->contact_phone_1 }}"
                            class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-l-lg flex items-center justify-center">
                            <i class="fas fa-phone"></i>
                        </a>
                        <a href="https://wa.me/6{{ $card->contact_phone_1 }}"
                            class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-r-lg flex items-center justify-center">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </div>
                </div>
            @endif
            @if ($card->contact_name_2 != null && $card->contact_phone_2 != null)
                <div class="flex items-center w-full">
                    <p class="flex-grow text-xl">
                        <i class="fas fa-user-circle mr-2"></i>{{ $card->contact_name_2 }}
                    </p>
                    <div class="grid grid-cols-2 text-xl">
                        <a href="tel:{{ $card->contact_phone_2 }}"
                            class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-l-lg flex items-center justify-center">
                            <i class="fas fa-phone"></i>
                        </a>
                        <a href="https://wa.me/6{{ $card->contact_phone_2 }}"
                            class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-r-lg flex items-center justify-center">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </div>
                </div>
            @endif
            @if (
                $card->contact_name_1 == null &&
                    $card->contact_phone_1 == null &&
                    $card->contact_name_2 == null &&
                    $card->contact_phone_2 == null)
                <p class="text-sm">Maklumat tidak lengkap</p>
            @endif
        </div>

        <div id="btn_close"
            class="w-12 h-12 bg-red-600 border-2 flex items-center justify-center text-white border-white rounded-full shadow-lg mb-2 mx-auto cursor-pointer hover:bg-red-500">
            <i class="fas fa-times"></i>
        </div>

        <p class="text-white mx-auto mb-4 text-xs uppercase">Close</p>
    </div>

    <script>
        new ClipboardJS('.copy');

        AOS.init();

        window.addEventListener("DOMContentLoaded", function() {
            new VenoBox({
                selector: ".venobox"
            });
        });

        $("#btn_rsvp").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_rsvp").toggleClass("hidden");
        });
        $("#btn_calendar").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_calendar").toggleClass("hidden");
        });
        $("#btn_location").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_location").toggleClass("hidden");
        });
        $("#btn_chatbot").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_chatbot").toggleClass("hidden");
        });
        $("#btn_money_gift").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_money_gift").toggleClass("hidden");
        });
        $("#btn_contacts").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_contacts").toggleClass("hidden");
        });
        $("#btn_close").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_rsvp").addClass("hidden");
            $("#modal_calendar").addClass("hidden");
            $("#modal_location").addClass("hidden");
            $("#modal_contacts").addClass("hidden");
            $("#modal_money_gift").addClass("hidden");
            $("#modal_chatbot").addClass("hidden");
        });
    </script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/venobox@2.0.4/dist/venobox.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.8.1/flowbite.min.js"></script>

    @livewireScripts

</body>

</html>
