<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-LCBDTMKX5Q"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-LCBDTMKX5Q');
    </script>

    <!--Open Graph Metatag-->
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ $card->title }}" />
    <meta property="og:description"
        content="{{ $card->subtitle }} | {{ date('d M Y', strtotime($card->date)) }} | {{ $card->location_name }}">
    <meta property="og:image" content="{{ url('/images/kkd-preview.png') }}" />
    <meta property="og:image:width" content="256" />
    <meta property="og:image:height" content="256" />
    <meta property="og:url" content="{{ url()->current() }}" />

    <!-- Chrome, Firefox OS and Opera -->
    <meta name="theme-color" content="#2dc8ff">
    <!-- Windows Phone -->
    <meta name="msapplication-navbutton-color" content="#2dc8ff">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#2dc8ff">

    <title>{{ config('app.name', 'Kad Kahwin Digital') }}</title>

    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('/images/apple-touch-icon.png') }}">
    <link rel="shortcut icon" href="{{ url('/favicon.ico') }}" type="image/x-icon">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
        integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/venobox@2.0.4/dist/venobox.min.css" type="text/css"
        media="screen" />


    <style type="text/css">
        @font-face {
            font-family: "Primary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_primary }}");
        }

        @font-face {
            font-family: "Secondary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_secondary }}");
        }

        body {
            font-family: "Outfit";
            background-attachment: fixed;
        }

        .design-page {
            color: {{ $card->theme->color }};
        }

        .design-text-primary {
            font-family: "Primary";
            text-transform: {{ $card->theme->style_primary }};
        }

        .design-text-secondary {
            font-family: "Secondary";

        }



        .kkd-card-body {
            font-family: "Secondary";
        }

        .kkd-card-body h2 {
            font-family: "Primary";
            font-size: 2em;
            font-weight: 700;
            margin-bottom: .75em;
        }

        .kkd-card-body h3 {
            font-size: 1.5em;
            font-weight: 700;
            margin-bottom: .75em;
        }

        .kkd-card-body p {
            font-size: 1em;
            font-weight: 400;
            margin-bottom: .5em;
        }

        .kkd-post-body ul {
            font-size: 1em;
            font-weight: 400;
            margin-bottom: 1em;
            padding-left: 1em;
        }

        .kkd-post-body ol {
            font-size: 1em;
            font-weight: 400;
            margin-bottom: 1em;
            padding-left: 1em;
        }

        .kkd-post-body ul li {
            font-size: 1em;
            font-weight: 400;
            margin-bottom: .5em;
        }

        .kkd-post-body ol li {
            font-size: 1em;
            font-weight: 400;
            margin-bottom: .5em;
        }

        .kkd-post-body a {
            font-size: 1em;
            font-weight: 400;
            margin-bottom: 1.25em;
            color: '#00aae6';
        }

        .kkd-post-body a:hover {
            color: '#2dc8ff';
        }

        .kkd-card-body .attachment__caption {
            display: none;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="//unpkg.com/alpinejs" defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>

    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2dc8ff',
                        prime: '#00aae6',
                    }
                }
            },
            darkMode: 'class',
        }
    </script>

    <script type="text/javascript">
        // Set the date we're counting down to
        var countDownDate = new Date("{{ $card->date }}").getTime();

        // Update the count down every 1 second
        var x = setInterval(function() {

            // Get today's date and time
            var now = new Date().getTime();

            // Find the distance between now and the count down date
            var distance = countDownDate - now;

            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element
            document.getElementById("text_days").innerHTML = days;
            document.getElementById("text_hours").innerHTML = hours;
            document.getElementById("text_seconds").innerHTML = seconds;
            document.getElementById("text_seconds").innerHTML = seconds;

            // If the count down is over, write some text
            if (distance < 0) {
                clearInterval(x);
                document.getElementById("countdown-block").setAttribute("class", "text-center");
                document.getElementById("countdown-block").innerHTML = "Event Have Started";
            }
        }, 1000);
    </script>

    @livewireStyles

    <!-- Matomo -->
    <script>
        var _paq = window._paq = window._paq || [];
        /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
        _paq.push(['trackPageView']);
        _paq.push(['enableLinkTracking']);
        (function() {
            var u = "//analytics.bookklik.com/";
            _paq.push(['setTrackerUrl', u + 'matomo.php']);
            _paq.push(['setSiteId', '2']);
            var d = document,
                g = d.createElement('script'),
                s = d.getElementsByTagName('script')[0];
            g.async = true;
            g.src = u + 'matomo.js';
            s.parentNode.insertBefore(g, s);
        })();
    </script>
    <!-- End Matomo Code -->

</head>

<body class="bg-gray-200">
    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center justify-center shadow-lg border-b border-gray-200 design-text-secondary design-page lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <img src="{{ url('/theme') }}/{{ $card->theme->code }}/bg_primary.jpg" class="w-full" />
        <div class="flex flex-col items-center absolute max-w-xs w-full px-6">

            <h1 class="text-4xl design-text-primary text-center">
                {{ $card->title }}
            </h1>
            <p class="mt-3">
                {{ $card->subtitle }}
            </p>
            <h3 class="mt-6 text-xl">{{ date('d M Y', strtotime($card->date)) }}</h3>
            <h6 class="mb-3">{{ $card->start_time }} - {{ $card->end_time }}</h6>
            <h3 class="text-xl text-center">
                {{ $card->location_name }}
            </h3>
        </div>
    </div>

    @if ($card->bg_music != null && $card->bg_music != '')
        <audio controls autoplay class="mx-auto w-full max-w-sm">
            <source src="{{ url('storage/' . $card->bg_music) }}" type="audio/mpeg">
        </audio>
    @endif

    <livewire:cards.advertisment-section />

    <div class="max-w-sm mx-auto bg-white w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary kkd-card-body lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">

        {!! $card->body !!}

        <div class="pt-12">
            <button id="btn_rsvp"
                class="px-4 py-3 bg-prime hover:bg-primary rounded-full w-full text-center text-white border border-2 border-gray-900">
                <i class="fas fa-calendar-check mr-2"></i>I Will Attend<span
                    class="bg-white text-prime text-sm px-2 py-1 ml-2 rounded-full">RSVP</span>
            </button>
        </div>
    </div>

    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center justify-center shadow-lg border-b border-gray-200 design-text-secondary design-page lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <img src="{{ url('/theme') }}/{{ $card->theme->code }}/bg_secondary.jpg" class="w-full" />
        <div class="flex flex-col items-center absolute max-w-xs w-full px-6">
            <h2 class="text-xl mb-12">SCHEDULE</h2>
            <table class="table table-borderless"
                style="color: {{ $card->theme->color }}; width: fit-content ;margin: 0 auto;">
                <tbody>
                    @foreach ($card->schedule as $key => $schedule)
                        <tr>
                            <td class="text-right pb-3">{{ $schedule['data']['time'] }}</td>
                            <td class="pl-6 pb-3">{{ $schedule['data']['activity'] }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <livewire:cards.advertisment-section />

    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <h2 class="text-xl mb-12">COUNTDOWN</h2>
        @php
            $count_date = explode('-', $card->date);
        @endphp
        <div class="grid grid-cols-4 w-full" id="countdown-block">
            <big><span id="text_days">0</span></big>
            <big><span id="text_hours">0</span></big>
            <big><span id="text_minutes">0</span></big>
            <big><span id="text_seconds">0</span></big>
            <span><small>Hari</small></span>
            <span><small>Jam</small></span>
            <span><small>Minit</small></span>
            <span><small>Saat</small></span>
        </div>
    </div>

    {{-- @if ($card->youtube_url != null || $card->youtube_url != '')
        <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white"
            data-aos="zoom-in-up" data-aos-duration="1000">
            <h2 class="text-xl mb-12">VIDEO LAGU</h2>
            @php
                $video_autoplay = $card->bg_music != null && $card->bg_music != '' ? 'autoplay;' : null;
            @endphp
            <iframe class="w-full aspect-video rounded-lg overflow-hidden" src="{{ $card->youtube_url }}?autoplay=1"
                frameborder="0"
                allow="accelerometer; {{ $video_autoplay }} encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen></iframe>
        </div>
    @endif --}}

    <div class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 bg-white lg:rounded-xl lg:overflow-hidden lg:my-3"
        data-aos="zoom-in-up" data-aos-duration="1000">
        <p class="mb-2 text-xs font-bold">POWERED BY</p>
        <a href="{{ url('/') }}">
            <img src="{{ url('/images/navbar_brand.svg') }}" class="w-full h-12" />
        </a>
        <p class="my-4">Follow Us</p>
        <div class="grid grid-cols-3 text-4xl gap-8">
            <a href="https://www.facebook.com/kadkahwindigital" target="_blank">
                <i class="fab fa-facebook"></i>
            </a>
            <a href="https://twitter.com/kaddigital" target="_blank">
                <i class="fab fa-twitter"></i>
            </a>
            <a href="https://www.instagram.com/kadkahwindigital.my/" target="_blank">
                <i class="fab fa-instagram"></i>
            </a>
        </div>
    </div>

    <div class="w-full h-16"></div>

    <div class="fixed w-full bg-gray-900 z-10 bottom-0">
        <div class="h-16 max-w-sm mx-auto grid grid-cols-3 text-white">
            <div id="btn_calendar"
                class="flex items-center justify-center flex-col hover:bg-black cursor-pointer grow">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <p class="text-xs">Calendar</p>
            </div>

            <div id="btn_chatbot" class="flex items-center justify-center flex-col cursor-pointer grow relative">
                <div class="w-full absolute -top-6 left-0 flex justify-center">
                    <div
                        class="flex items-center justify-center w-12 h-12 bg-prime hover:bg-primary rounded-full border-2 border-gray-900 overflow-hidden">
                        <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-cover" />
                    </div>
                </div>
                <div class="mb-2 w-4 h-4 text-white"></div>
                <p class="text-xs text-primary font-bold">Chat AI</p>
            </div>
            <div id="btn_location"
                class="flex items-center justify-center flex-col hover:bg-black cursor-pointer grow">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-map-marked-alt"></i>
                </div>
                <p class="text-xs">Location</p>
            </div>
        </div>
    </div>

    <div
        class="hidden fixed kkd-backdrop w-full h-full bg-gray-800 bg-opacity-90 top-0 z-20 flex flex-col justify-end px-4">

        <div id="modal_rsvp"
            class="max-w-sm w-full rounded-2xl bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden overflow-hidden">
            <livewire:cards.generic-attendance-modal :card="$card" />
        </div>

        <div id="modal_calendar"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            <h1 class="text-3xl font-bold">{{ date('d M Y', strtotime($card->date)) }}</h1>
            <h6 class="mb-4">{{ $card->start_time }} - {{ $card->end_time }}</h6>
            @php
                $event_date = str_replace('-', '', $card->date);
                $event_start = str_replace(':', '', $card->start_time);
                $event_end = str_replace(':', '', $card->end_time);
            @endphp
            <button id="btn-add-to-calendar" type="button"
                class="p-4 bg-gray-200 hover:bg-gray-300 rounded-lg w-full text-center"
                onclick="window.open('https://calendar.google.com/calendar/r/eventedit?text={{ $card->title }}&dates={{ $event_date }}T{{ $event_start }}00%2F{{ $event_date }}T{{ $event_end }}00&details={{ $card->body }}%0A%0AAlamat+%3A2%2C+{{ $card->location_address }}&location={{ $card->location_name }}&sf=true&output=xml', '_blank')">
                <i class="fas fa-calendar-plus mr-2"></i>Add to Calendar
            </button>
        </div>

        <div id="modal_location"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            @if ($card->location_coordinate != null && $card->location_coordinate != '')
                <h6 class="mb-4 text-xl text-center">{{ $card->location_name }}</h6>
                <div class="grid grid-cols-2 w-full">
                    <a href="https://maps.google.com/maps?daddr={{ $card->location_coordinate }}&navigate=yes"
                        class="p-4 bg-gray-200 hover:bg-gray-300 rounded-l-lg w-full text-center">
                        <i class="fas fa-map-marker-alt mr-2"></i>Maps
                    </a>
                    <a href="https://waze.com/ul?q={{ $card->location_coordinate }}&navigate=yes&zoom=17"
                        class="p-4 bg-gray-200 hover:bg-gray-300 rounded-r-lg w-full text-center">
                        <i class="fab fa-waze mr-2"></i>Waze
                    </a>
                </div>
            @else
                <p class="text-sm">Maklumat tidak lengkap</p>
            @endif
        </div>

        <div id="modal_chatbot"
            class="max-w-sm w-full rounded-2xl bg-white mx-auto mb-8 shadow-lg flex flex-col items-center overflow-hidden hidden">
            <livewire:chatbot.show-generic-card-modal :card="$card" />
        </div>

        <div id="btn_close"
            class="w-12 h-12 bg-red-600 border-2 flex items-center justify-center text-white border-white rounded-full shadow-lg mb-2 mx-auto cursor-pointer hover:bg-red-500">
            <i class="fas fa-times"></i>
        </div>

        <p class="text-white mx-auto mb-4 text-xs uppercase">Close</p>
    </div>

    <script>
        new ClipboardJS('.copy');

        AOS.init();

        window.addEventListener("DOMContentLoaded", function() {
            new VenoBox({
                selector: ".venobox"
            });
        });

        $("#btn_rsvp").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_rsvp").toggleClass("hidden");
        });
        $("#btn_calendar").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_calendar").toggleClass("hidden");
        });
        $("#btn_location").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_location").toggleClass("hidden");
        });
        $("#btn_chatbot").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_chatbot").toggleClass("hidden");
        });
        $("#btn_close").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_rsvp").addClass("hidden");
            $("#modal_calendar").addClass("hidden");
            $("#modal_location").addClass("hidden");
            $("#modal_chatbot").addClass("hidden");
        });
    </script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/venobox@2.0.4/dist/venobox.min.js"></script>

    @livewireScripts

</body>

</html>
