<x-filament-widgets::widget>

    <div class="pb-6 flex justify-between font-semibold items-center">
        <p class="text-gray-500">Kad Kahwin ({{ $displayedCards->count() }}/{{ $cards->count() }})</p>
        <a href="{{ url('/app/cards') }}" class="text-primary-600 border rounded-lg hover:bg-white px-3 py-1 border-primary-600">View All</a>
    </div>

    <div class="grid grid-col-1 lg:grid-cols-3 gap-6">
        @foreach ($displayedCards as $card)
            <div class="rounded-lg overflow-hidden shadow" x-data="{ openMore: false }">
                <div class="relative">
                    <img src="{{ url('/theme/' . $card->theme_code . '/preview.jpg') }}" class="w-full">
                    <div class="absolute bottom-0 right-0 text-center w-full h-full flex-col p-4 text-white flex items-center justify-end"
                        style="background-image: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.75));">
                        <div class="flex-grow w-full relative">
                            <a href="{{ route('cards.print', $card->id) }}"
                                class="px-4 w-full h-10 flex text-sm font-bold bg-white text-black hover:bg-gray-100 flex items-center justify-center max-w-min shadow-lg rounded-bl-lg absolute -top-4 -right-4">
                                <x-heroicon-o-printer class="h-4 mr-1" />Print/PDF
                            </a>
                        </div>
                        <div class="w-12 mb-4"><x-heroicon-s-envelope-open class="shadow-lg" /></div>
                        <p>{{ $card->male_short_name }} & {{ $card->female_short_name }}</p>
                        <p>{{ date('d M Y', strtotime($card->date_masihi)) }}</p>
                    </div>
                    <div class="absolute top-0 left-0 w-full h-full bg-white flex flex-col" x-show="openMore">
                        <div class="p-4 flex items-center justify-center border-b bg-gray-100">More Options</div>
                        <div class="flex-grow flex flex-col overflow-auto">
                            <a href="{{ route('cards.metaverse', $card->id) }}"
                                class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                <p class="w-12 py-3 text-center text-lg">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" xmlns="http://www.w3.org/2000/svg" class="h-6">
                                        <g><path d="M2 5C8 9 16 9 22 5V19C16 15 8 15 2 19V5ZM8 13 12 11 12 13 16 11"></path></g>
                                    </svg>
                                </p>
                                <div class="flex items-center">
                                    3D Metaverse
                                </div>
                            </a>
                            <a href="https://www.facebook.com/sharer.php?u={{ url('/cards/' . $card->id) }}"
                                class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                <p class="w-12 py-3 text-center text-lg">
                                    <x-fab-facebook class="h-6" />
                                </p>
                                <div class="flex items-center">
                                    Facebook
                                </div>
                            </a>
                            <a href="https://twitter.com/share?url={{ url('/cards/' . $card->id) }}&text=Kad%20Kahwin%20Digital&hashtags=kkd"
                                class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                <p class="w-12 py-3 text-center text-lg">
                                    <x-fab-twitter class="h-6" />
                                </p>
                                <div class="flex items-center">
                                    Twitter / X
                                </div>
                            </a>
                            <a href="https://wa.me/?text=Kad%20Kahwin%20Digital%20-%20{{ url('/cards/' . $card->id) }}"
                                class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                <p class="w-12 py-3 text-center text-lg">
                                    <x-fab-whatsapp class="h-6" />
                                </p>
                                <div class="flex items-center">
                                    WhatsApp
                                </div>
                            </a>
                            <a href="{{ route('cards.print', $card->id) }}"
                                class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                <p class="w-12 py-3 text-center text-lg">
                                    <x-heroicon-o-printer class="h-6" />
                                </p>
                                <div class="flex items-center">
                                    Print/PDF
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="bg-white grid grid-cols-3 text-black text-sm font-semibold border-t">
                    <a href="{{ url('/cards/' . $card->id) }}"
                        class="p-4 flex items-center justify-center hover:bg-gray-100 border-r" target="_blank">
                        View
                    </a>
                    <a href="{{ url('/app/cards/' . $card->id . '/edit') }}"
                        class="p-4 flex items-center justify-center hover:bg-gray-100 border-r">
                        Edit
                    </a>
                    <button class="p-4 flex items-center justify-center hover:bg-gray-100"
                        @click="openMore = !openMore">
                        More
                    </button>
                </div>
            </div>
        @endforeach
        <a href="{{ url('app/cards/create') }}"
            class="rounded-lg overflow-hidden bg-primary-600 hover:bg-primary-700 shadow-lg">
            <div class="relative">
                <div class="w-full" style="padding-top: 100%"></div>
                <div class="absolute bottom-0 right-0 w-full h-full flex-col p-4 flex items-center justify-center"
                    style="background-image: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.25));">
                    <div class="w-12"><x-heroicon-s-plus-circle class="text-white" /></div>
                </div>
            </div>
            <div class="text-white text-sm p-4 flex items-center justify-center">
                Cipta Kad Kahwin Baru
            </div>
        </a>
    </div>

    @if ($combos->count() > 0)

        <div>
            <div class="mt-12">
                <h2 class="text-2xl font-semibold">Combo cards ({{ $combos->count() }})</h2>
                <p class="text-gray-500">Kad Kahwin Kombinasi adalah kad kahwin yang dibina daripada 2 kad kahwin yang
                    sedia ada.</p>
            </div>
        </div>

        <div class="grid grid-col-1 md:grid-cols-3 gap-4 mt-12">
            @foreach ($combos as $combo)
                <div class="rounded-lg overflow-hidden shadow">
                    <div class="relative">
                        <div class="w-full grid grid-cols-2 gap-1 bg-gray-900 relative">
                            <div
                                style="padding-top: 200%; background-image: url('{{ url('/theme/' . $combo->cards()->first()->theme_code . '/sneak_view.jpg') }}'); background-position: left top; background-size: cover;">
                            </div>
                            <div
                                style="padding-top: 200%; background-image: url('{{ url('/theme/' . $combo->cards()->last()->theme_code . '/sneak_view.jpg') }}'); background-position: right top; background-size: cover;">
                            </div>
                            <div class="absolute top-4 w-full">
                                <div class="w-16 h-16 mx-auto bg-gray-900 rounded-full p-2 text-white">
                                    <x-heroicon-m-arrow-path />
                                </div>

                            </div>
                        </div>
                        <div class="absolute bottom-0 right-0 text-center w-full h-full flex-col p-4 text-white flex items-center justify-end"
                            style="background-image: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.75));">
                            <div class="w-12 mb-4">
                                <x-heroicon-s-document-plus class="shadow-lg" />
                            </div>
                            <p>{{ $combo->title }}</p>
                        </div>
                    </div>
                    <div class="bg-white grid grid-cols-3 text-black text-sm font-semibold">
                        <a href="{{ url('/cards/combo/' . $combo->id) }}"
                            class="p-4 flex items-center justify-center hover:bg-gray-200 border-r" target="_blank">
                            View
                        </a>
                        <a href="{{ url('/app/combo-cards/' . $combo->id . '/edit') }}"
                            class="p-4 flex items-center justify-center hover:bg-gray-200 border-r">
                            Edit
                        </a>
                        <a href="" class="p-4 flex items-center justify-center hover:bg-gray-200">
                            More
                        </a>
                    </div>
                </div>
            @endforeach
            <a href="{{ url('app/combo-cards/create') }}"
                class="rounded-lg overflow-hidden bg-gray-800 hover:bg-gray-900 shadow-lg">
                <div class="relative">
                    <div class="w-full" style="padding-top: 100%"></div>
                    <div class="absolute bottom-0 right-0 w-full h-full flex-col p-4 flex items-center justify-center"
                        style="background-image: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.75));">
                        <div class="w-12"><x-heroicon-s-plus-circle class="shadow-lg text-white" /></div>
                    </div>
                </div>
                <div class="text-white text-sm p-4 flex items-center justify-center">
                    Gabungkan Kad Kahwin
                </div>
            </a>
        </div>

    @endif

    <div class="flex gap-4 fixed bottom-4 lg:bottom-8 right-4 lg:right-8 items-center">
        <p class="px-2 py-1 bg-white shadow rounded-md z-50">Buat Kad Kahwin<br> Guna Ejen AI 😄</p>
        <a href="{{ route('filament.app.pages.ai-agent') }}" class="relative bg-primary-600 hover:bg-primary-700 shadow-lg rounded-full duration-300 p-1 w-16 h-16">
            <span class="animate-ping duration-1000 absolute top-0 left-0 inline-flex h-full w-full rounded-full bg-sky-400 opacity-75"></span>
            <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo" class="w-full h-full object-contain rounded-full z-50">
        </a>
    </div>

</x-filament-widgets::widget>
