<x-filament-widgets::widget>
    {{-- <x-filament::section>
    </x-filament::section> --}}

    <div class="pb-6 flex justify-between font-semibold items-center">
        <p class="text-gray-500">Generic Cards ({{ $displayedCards->count() }}/{{ $cards->count() }})</p>
        <a href="{{ url('/app/generic-cards') }}"
            class="text-primary-600 border rounded-lg hover:bg-white px-3 py-1 border-primary-600">View All</a>
    </div>

    <div class="flex flex-col gap-6 w-full mb-16">
        @foreach ($displayedCards as $card)
            <div class="rounded-lg overflow-hidden shadow bg-white grid lg:grid-cols-3" x-data="{ openMore: false }">
                <div class="px-6 py-3">
                    <p class="font-semibold">{{ $card->title }}</p>
                    <p class="text-gray-500 text-sm">{{ $card->subtitle }}</p>
                </div>
                <div
                    class="px-6 py-1 lg:py-3 flex items-center justify-center bg-gray-50 lg:bg-white border-t border-b lg:border-0">
                    <p class="px-3 py-1 border rounded-lg border-white lg:border-gray-300 text-sm">{{ $card->date }}
                    </p>
                </div>
                <div class="flex justify-end">
                    <div class="grid grid-cols-3 w-full lg:max-w-max font-semibold text-sm">
                        <a href="{{ url('/cards/generic/' . $card->id) }}"
                            class="h-full px-6 py-4 flex justify-center items-center hover:bg-gray-100 lg:border-l border-r lg:border-r-0"
                            target="_blank">View</a>
                        <a href="{{ url('/app/generic-cards/' . $card->id . '/edit') }}"
                            class="h-full px-6 py-4 flex items-center justify-center hover:bg-gray-100 lg:border-l border-r lg:border-r-0">Edit</a>
                        <button
                            class="h-full px-6 py-4 flex items-center justify-center hover:bg-gray-100 lg:border-l" @click="openMore = !openMore">More</button>
                    </div>
                </div>
                <div class="lg:col-span-3 px-6 py-2 border-t flex flex-col lg:flex-row gap-3" x-show="openMore">
                    <p class="font-semibold text-xs py-2">SHARE:</p>
                    <a href="https://www.facebook.com/sharer.php?u={{ url('/cards/generic/' . $card->id) }}"
                        class="lg:px-3 py-1 flex hover:bg-gray-100 rounded-lg" target="_blank">
                        <p class="w-8 text-center text-lg">
                            <x-fab-facebook class="h-6" />
                        </p>
                        <div class="flex items-center">
                            Facebook
                        </div>
                    </a>
                    <a href="https://twitter.com/share?url={{ url('/cards/generic/' . $card->id) }}&text=Kad%20Kahwin%20Digital&hashtags=kkd"
                        class="lg:px-3 py-1 flex hover:bg-gray-100 rounded-lg" target="_blank">
                        <p class="w-8 text-center text-lg">
                            <x-fab-twitter class="h-6" />
                        </p>
                        <div class="flex items-center">
                            Twitter / X
                        </div>
                    </a>
                    <a href="https://wa.me/?text=Kad%20Kahwin%20Digital%20-%20{{ url('/cards/generic/' . $card->id) }}"
                        class="lg:px-3 py-1 flex hover:bg-gray-100 rounded-lg" target="_blank">
                        <p class="w-8 text-center text-lg">
                            <x-fab-whatsapp class="h-6" />
                        </p>
                        <div class="flex items-center">
                            WhatsApp
                        </div>
                    </a>
                    <div class="pt-1 lg:pt-0"></div>
                </div>
            </div>
        @endforeach
        <a href="{{ url('/app/generic-cards/create') }}" class="rounded-lg shadow bg-primary-600 hover:bg-primary-700 text-white flex items-center justify-center text-sm">
            <div class="flex gap-3 p-4 items-center">
                <div class="w-6"><x-heroicon-s-plus-circle /></div>
                <p>Create New Card</p>
            </div>
        </a>
    </div>

</x-filament-widgets::widget>
