<x-app-layout>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-8">
                About Us
            </h1>

            <div
                class="space-y-8 relative before:absolute before:inset-0 before:ml-5 before:-translate-x-px md:before:mx-auto md:before:translate-x-0 before:h-full before:w-0.5 before:bg-gradient-to-b before:from-transparent before:via-slate-300 before:to-transparent">

                <!-- Item #1 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital</div>
                            <time class="font-caveat font-medium text-prime">2016</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <img src="{{ asset('images/about/kkd_2016.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32 rounded-lg">
                            <p>
                                Bermula sebagai perkhidmatan membuat aplikasi Android sebagai alternatif kad kahwin
                                tradisional. Membentuk batu asas untuk kad kahwin digital dengan fungsi navigasi ke
                                lokasi & imbas QR Code.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            <a href="{{ asset('images/about/2016/slide2.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2016/slide2.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2016/slide3.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2016/slide3.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2016/slide4.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2016/slide4.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #2 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital Micro</div>
                            <time class="font-caveat font-medium text-prime">2017</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <img src="{{ asset('images/about/kkd_2017.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32">
                            <p>
                                Buat pertama kalinya, kad kahwin digital menjadi versi web. Pengguna boleh daftar akaun
                                & buat kad kahwin digital mereka sendiri secara percuma. Memperkenalkan fungsi
                                peringatan majlis di kalendar Google. Warna tema juga telah ditukar dari oren ke biru.
                            </p>
                        </div>
                        <div class="grid grid-cols-1 mt-4">
                            <iframe src="https://www.youtube.com/embed/VzhBmqBRsBw" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen class="aspect-video w-full"></iframe>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            <a href="{{ asset('images/about/2017/slide1.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2017/slide1.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2017/slide2.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2017/slide2.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2017/slide3.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2017/slide3.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #3 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">KadKahwinDigital.my</div>
                            <time class="font-caveat font-medium text-prime">2019</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <img src="{{ asset('images/about/kkd_2019.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32 rounded-lg">
                            <p>
                                Dilancarkan sebagai platform web untuk memudahkan pengguna membuat kad kahwin digital
                                mereka sendiri. Membawakan fungsi galeri gambar, video lagu dari YouTube & reka bentuk
                                sistem yang lebih mesra pengguna. Logo baru juga diperkenalkan untuk memberikan imej
                                yang lebih moden.
                            </p>
                        </div>
                        <div class="grid grid-cols-1 mt-4">
                            <iframe src="https://www.youtube.com/embed/PtCm_gq3qN4" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen class="aspect-video w-full"></iframe>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            {{-- <div>
                                <img src="{{ asset('images/about/2019/slide1.jpg') }}" alt="Kad Kahwin Digital" class="w-full rounded-lg shadow">
                            </div> --}}
                            <a href="{{ asset('images/about/2019/slide2.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2019/slide2.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2019/slide3.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2019/slide3.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2019/slide4.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2019/slide4.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #4 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">PKP (Covid-19)</div>
                            <time class="font-caveat font-medium text-prime">2020</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            {{-- <img src="{{ asset('images/about/kkd_chat_ai_2023.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32 rounded-lg"> --}}
                            <p>
                                Dengan adanya PKP, kami memperkenalkan fungsi RSVP untuk memudahkan pengantin
                                menguruskan senarai tetamu hadir. Fungsi reaksi emoji juga ditambah bagi membolehkan
                                tetamu menunjukan tanda mereka meraikan pengantin.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            <a href="{{ asset('images/about/2020/slide1.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2020/slide1.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2020/slide2.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2020/slide2.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2020/slide3.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2020/slide3.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #5 -->
                <div class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital + Chat AI</div>
                            <time class="font-caveat font-medium text-prime">2023</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <div class="relative w-24 h-24 lg:w-32 lg:h-32 shrink-0">
                                <img src="{{ asset('images/about/kkd_2019.png') }}" alt="Kad Kahwin Digital"
                                class="absolute top-0 left-0 w-20 h-20 lg:w-28 lg:h-28 rounded-lg">
                                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="Kad Kahwin Digital"
                                class="absolute bottom-0 right-0 w-10 h-10 lg:w-12 lg:h-12 rounded-full">
                            </div>
                            <p>
                                Naik taraf terkini untuk Kad Kahwin Digital. Seluruh sistem dibangunkan semula dengan
                                menggunakan teknologi terkini. Fungsi Chat AI juga ditambah bagi membolehkan tetamu
                                mendapatkan maklumat terkini mengenai majlis.
                            </p>
                        </div>
                        <div class="grid grid-cols-1 mt-4">
                            <iframe src="https://www.youtube.com/embed/EpTQjhtzH2A" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen class="aspect-video w-full"></iframe>
                        </div>
                    </div>
                </div>

                <!-- Item #6 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital x SenangWebs</div>
                            <time class="font-caveat font-medium text-prime">2024</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <div class="relative w-24 h-24 lg:w-32 lg:h-32 shrink-0">
                                <img src="{{ asset('images/about/kkd_2019.png') }}" alt="Kad Kahwin Digital"
                                class="absolute top-0 left-0 w-16 h-16 lg:w-20 lg:h-20 rounded-lg">
                                <img src="{{ asset('images/about/senangwebs.svg') }}" alt="Kad Kahwin Digital"
                                class="absolute bottom-0 right-0 w-12 h-12 lg:w-20 lg:h-20 rounded-lg">
                            </div>
                            <p>
                                Kad Kahwin Digital bekerjasama dengan platform membuat laman sesawang, <a href="https://use.senangwebs.com/" target="_blank" class="text-primary hover:underline font-semibold">SenangWebs</a>. Pengguna boleh menyambungkan akaun mereka untuk membuat kad digital atau eKad dengan editor laman web SenangWebs.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-2 gap-2 mt-4">
                            <a href="{{ asset('images/about/2024/senangwebs_kadkahwindigital_1.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2024/senangwebs_kadkahwindigital_1.png') }}" alt="Kad Kahwin Digital x SenangWebs
"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2024/senangwebs_kadkahwindigital_2.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2024/senangwebs_kadkahwindigital_2.png') }}" alt="Kad Kahwin Digital x SenangWebs"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #7 -->
                <div class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-prime group-[.is-active]:bg-emerald-500 text-white group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-star"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital + Ejen AI</div>
                            <time class="font-caveat font-medium text-prime">2025</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <div class="relative w-24 h-24 lg:w-32 lg:h-32 shrink-0">
                                <img src="{{ asset('images/about/kkd_2019.png') }}" alt="Kad Kahwin Digital"
                                class="absolute top-0 left-0 w-20 h-20 lg:w-28 lg:h-28 rounded-lg">
                                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="Kad Kahwin Digital"
                                class="absolute bottom-0 right-0 w-10 h-10 lg:w-12 lg:h-12 rounded-full">
                            </div>
                            <p>
                                Selaras trending teknologi semasa, Kad Kahwin Digital menggunakan teknologi Ejen AI untuk membantu pengguna membuat kad
                                kahwin digital mereka sendiri.<br><br>
                                Baca: <a href="https://kad-kahwin-digital.use.senangwebs.com/blog/post/cara-buat-kad-kahwin-digital-guna-komputeripad" class="text-primary hover:underline font-semibold" target="_blank">Cara buat kad kahwin digital guna Ejen AI</a>
                            </p>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </div>

</x-app-layout>
