<x-app-layout>

    <div class="w-full min-h-screen bg-white flex items-center justify-center px-6 py-20 relative"
        style="background-image: url('{{ url('/images/bg_hero.jpg') }}'); background-size: cover; background-position: center">

        <div class="w-full h-full bg-white bg-opacity-80 absolute top-0 left-0 backdrop-blur-sm"></div>

        <div class="flex flex-col lg:flex-row z-10 gap-12">
            <div class="flex flex-col items-center">
                <div class="pb-12 flex flex-col w-full">
                    <h1 class="text-4xl lg:text-6xl font-bold text-gray-900">Kad Kahwin Digital</h1>
                    <h1 class="text-4xl lg:text-6xl font-bold text-prime">No.1 di Malaysia</h1>
                </div>
                <div class="max-w-2xl flex flex-col gap-3">
                    <div class="flex gap-3 lg:gap-6">
                        <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden shrink-0">
                            <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-fit">
                        </div>
                        <div>
                            <div class="py-2 px-4 rounded-xl bg-white shadow-md">
                                <p class="lg:text-xl font-semibold">PERCUMA! FREE! buat Kad Kahwin Digital + AI</p>
                            </div>
                        </div>
                        <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden shrink-0"></div>
                    </div>
                    <div class="flex gap-3 lg:gap-6">
                        <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden shrink-0 flex-grow"></div>
                        <div>
                            <div class="py-2 px-4 rounded-xl bg-gray-100 shadow-md">
                                <p class="lg:text-xl">wow menarik ni! macam mana nak buat?</p>
                            </div>
                        </div>
                        <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden shrink-0">
                            <img src="{{ url('/images/chat_ai_kkd_profile_2.png') }}" class="object-fit">
                        </div>
                    </div>
                    <div class="flex gap-3 lg:gap-6">
                        <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden shrink-0">
                            <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-fit">
                        </div>
                        <div class="flex flex-col gap-4">
                            <div class="py-2 px-4 rounded-xl bg-white shadow-md">
                                <p class="lg:text-xl">senang je... tekan butang dibawah
                                </p>
                            </div>
                            <div
                            class="flex flex-col lg:flex-row w-full font-semibold gap-4">
                                <a href="{{ route('login') }}"
                                    class="p-3 hover:bg-prime bg-primary text-white text-center tracking-widest flex gap-2 items-center justify-center relative shadow-md order-1 lg:order-2 rounded-xl">
                                    <span class="relative flex h-4 w-4">
                                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-white opacity-75"></span>
                                        <span class="relative inline-flex rounded-full h-4 w-4 bg-white"></span>
                                    </span>
                                    <span>BUAT KAD KAHWIN</span>
                                    {{-- <i class="fas fa-arrow-right"></i> --}}
                                </a>
                                <a href="{{ route('theme.index') }}"
                                    class="p-3 bg-white hover:bg-gray-100 text-center tracking-widest shadow-md order-2 lg:order-1 rounded-lg z-10">
                                    LIHAT CONTOH
                                </a>
                            </div>
                        </div>
                        <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden shrink-0"></div>
                    </div>
                </div>
            </div>
            <div class="shadow-lg rounded-xl flex-col flex gap-1 border-2 bg-pink-50 border-pink-200 text-pink-400">
                <div class="flex flex-col gap-2 p-6 justify-center items-center">
                    <p class="text-lg lg:text-2xl font-bold tracking-wide">Tak Payah <span
                            class="bg-red-600 text-sm lg:text-xl text-white rounded-lg px-2 py-1 uppercase">Bayar</span>
                        Dulu!</p>
                    <p class="text-lg lg:text-2xl font-bold tracking-wide">Tak Payah <span
                            class="bg-amber-600 text-sm lg:text-xl text-white rounded-lg px-2 py-1 uppercase">Booking</span>
                        Dulu!</p>
                    <p class="text-lg lg:text-2xl font-bold tracking-wide"><span
                            class="bg-green-600 text-sm lg:text-xl text-white rounded-lg px-2 py-1 uppercase">Edit</span>
                        Bila<sup>2</sup> Masa!</p>
                    <p class="text-lg lg:text-2xl font-bold tracking-wide">Ada Fungsi <span
                            class="bg-prime text-sm lg:text-xl text-white rounded-lg px-2 py-1 uppercase">Chat
                            AI</span></p>
                </div>
                <div class="mt-auto px-12">
                    <img src="{{ url('/images/model_happy_phone.png') }}" class="mx-auto w-full lg:w-48">
                </div>
            </div>
        </div>


    </div>

    <div class="w-full bg-gray-800 flex items-center justify-center p-6 relative mb-12 lg:mb-24">
        <div class="flex flex-col items-center">
            <p class="text-white mb-3 uppercase tracking-widest">Jenama Yang Dipercayai</p>
            <div class="grid grid-cols-2 lg:grid-cols-3 gap-4 max-w-4xl">
                <img src="{{ url('/images/badge_cards.png') }}" class="w-full order-2 lg:order-1 lg:scale-75">
                <img src="{{ url('/images/badge_users.png') }}" class="w-full order-1 lg:order-2 col-span-2 lg:col-span-1">
                <img src="{{ url('/images/badge_years.png') }}" class="w-full order-3 lg:scale-75">
            </div>
        </div>
    </div>

    {{-- <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <iframe src="https://www.youtube.com/embed/EpTQjhtzH2A" title="YouTube video player" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                allowfullscreen class="aspect-video w-full rounded-xl"></iframe>
        </div>
    </div> --}}

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8 flex flex-col gap-12 lg:gap-24">
            {{-- <div class="bg-white rounded-xl grid lg:grid-cols-2 overflow-hidden shadow">
                <div class="p-6 lg:p-12 flex flex-col justify-between gap-6 order-2 lg:order-1">
                    <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-left">Kad Kahwin Digital<br> +
                        <img src="{{ url('/images/chat_ai_kkd_profile.png') }}"
                            class="w-8 lg:w-12 inline-block rounded-full mb-2 lg:mb-3">
                        <span class="text-prime">Ejen AI</span>

                    </h1>

                    <p class="lg:text-xl">
                        Kad Kahwin Digital pertama yang dilengkapi dengan Chat AI, chatbot yang boleh berbual dengan
                        tetamu anda. Ia akan memberikan maklumat mengenai majlis anda dan juga boleh menjawab
                        soalan-soalan yang sering ditanya oleh tetamu anda.
                    </p>
                </div>
                <div class="bg-prime order-1 lg:order-2">
                    <img src="{{ url('/images/chat_ai_demo.png') }}" class="w-full h-full object-covered">
                </div>
            </div> --}}
            <div class="bg-white rounded-xl grid lg:grid-cols-2 overflow-hidden shadow">
                <div class="bg-prime">
                    <img src="{{ url('/images/chat_ai_demo.png') }}" class="w-full h-full object-cover">
                </div>
                <div class="p-6 lg:p-12 flex flex-col justify-between gap-6">
                    <iframe src="https://www.youtube.com/embed/EpTQjhtzH2A" title="YouTube video player" frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                    allowfullscreen class="aspect-video w-full rounded-xl"></iframe>

                    <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-left">Kad Kahwin Digital<br> +
                        <img src="{{ url('/images/chat_ai_kkd_profile.png') }}"
                            class="w-8 lg:w-12 inline-block rounded-full mb-2 lg:mb-3">
                        <span class="text-prime">Chat AI</span>

                    </h1>

                    <p class="lg:text-xl">
                        Kad Kahwin Digital pertama yang dilengkapi dengan Chat AI, chatbot yang boleh berbual dengan
                        tetamu anda. Ia akan memberikan maklumat mengenai majlis anda dan juga boleh menjawab
                        soalan-soalan yang sering ditanya oleh tetamu anda.
                    </p>

                    <div class="gap-6 flex flex-col" x-data="{ chat: false }">
                        <div class="flex">
                            <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden mr-3 shrink-0">
                                <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-fit">
                            </div>
                            <div class="flex-grow">
                                <p class="font-semibold text-prime">Chat AI</p>
                                <p class="">Salam, saya Chat AI. Ada apa-apa yang boleh saya bantu?</p>
                            </div>
                        </div>
                        <div class="flex" x-show="chat" x-transition.delay.500ms>
                            <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden mr-3 shrink-0">
                                <img src="{{ url('/images/chat_ai_kkd_profile_2.png') }}" class="object-fit">
                            </div>
                            <div class="flex-grow">
                                <p class="font-semibold">Guest</p>
                                <p class="">Saya nak buat kad kahwin digital yang ada Chat AI</p>
                            </div>
                        </div>
                        <div class="flex" x-show="chat" x-transition.delay.1000ms>
                            <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden mr-3 shrink-0">
                                <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-fit">
                            </div>
                            <div class="flex-grow">
                                <p class="font-semibold text-prime">Chat AI</p>
                                <p class="mb-4">Sila tekan butang "Mula Buat" di bawah untuk mula buat kad kahwin
                                    digital
                                    anda</p>
                                <a href="{{ route('login') }}">
                                    <x-secondary-button class="flex justify-center">
                                        Mula Buat
                                    </x-secondary-button>
                                </a>
                            </div>
                        </div>
                        <div class="flex gap-3 w-full flex-col lg:flex-row" x-show="!chat" x-transition.duration.500ms>
                            <div class="flex-grow border border-gray-300 rounded-lg py-3 px-4 lg:truncate">
                                saya nak buat kad kahwin digital yang ada Chat AI
                            </div>
                            <button class="bg-green-600 text-white px-6 py-3 rounded-lg animate-pulse"
                                @click="chat = true">
                                SEND
                            </button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="grid lg:grid-cols-2">
                <div>
                    <img src="{{ url('/images/example.png') }}" class="mx-auto">
                </div>
                <div class="flex flex-col justify-center pt-12 lg:pt-24">
                    <h1 class="text-2xl lg:text-4xl font-bold text-gray-900 mb-8 lg:mb-12">Kad Kahwin Digital<br>Untuk
                        <span class="text-prime">Hari Isitimewa</span> Anda
                    </h1>
                    <p class="mb-4 lg:-ml-12">
                        Dengan kad kahwin digital kami, urusan jemputan kahwin akan menjadi lebih senang dan teratur. Ia
                        juga memudahkan tetamu anda untuk mengakses dan boleh menggunakan fungsi-fungsi seperti:
                    </p>
                    <ul class="lg:-ml-12">
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>Chat AI: Tetamu boleh
                            berbual dengan chatbot
                            untuk dapatkan maklumat majlis
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>RSVP: Tetamu boleh
                            menghantar status
                            kehadiran mereka
                            kepada pihak majlis
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>PDF: Anda boleh download
                            format PDF & hantar kepada tetamu anda
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-8">Cara <span
                    class="text-prime">Mudah</span> Buat<br>Kad Kahwin
                Digital
            </h1>
            <div class="grid lg:grid-cols-4 gap-6">
                <div class="flex flex-col items-center">
                    <div class="w-32 h-32 rounded-full shadow bg-white flex items-center justify-center text-6xl">
                        <i class="fas fa-sign-in-alt"></i>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-900 mt-4">Daftar Akaun</h1>
                    <p class="text-gray-900 text-center mt-2">Daftar akaun percuma dengan klik butang <a
                            href="{{ route('login') }}" class="text-prime font-medium">"Login"</a></p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="w-32 h-32 rounded-full shadow bg-white flex items-center justify-center text-6xl">
                        <i class="fas fa-palette"></i>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-900 mt-4">Pilih Design</h1>
                    <p class="text-gray-900 text-center mt-2">Beli tema design pilihan anda atau guna design yang FREE
                    </p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="w-32 h-32 rounded-full shadow bg-white flex items-center justify-center text-6xl">
                        <i class="fas fa-edit"></i>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-900 mt-4">Isi Butiran</h1>
                    <p class="text-gray-900 text-center mt-2">Isi butiran majlis anda dan muat naik gambar anda</p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="w-32 h-32 rounded-full shadow bg-white flex items-center justify-center text-6xl">
                        <i class="fas fa-share-alt"></i>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-900 mt-4">Siap & Kongsi</h1>
                    <p class="text-gray-900 text-center mt-2">Kad anda siap & Kongsi ke Facebook, Instagram dan
                        WhatsApp</p>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="grid lg:grid-cols-2">
                <div class="flex flex-col justify-center mb-6 lg:mb-0">
                    <h1 class="text-2xl lg:text-4xl font-bold text-gray-900 mb-8">Kenapa Perlu Kad Kahwin Digital?</h1>
                    <p class="mb-4">
                        Kad kahwin digital boleh dikongsi ke platform media sosial seperti Facebook, Instagram dan juga
                        WhatsApp. KKD menjadi semakin popular kerana amat memudahkan pihak majlis dan tetamu. Antara
                        kelebihan
                        menggunakan kad kahwin digital adalah:
                    </p>
                    <ul class="">
                        <li class="flex mb-2">
                            <i class="fas fa-check-circle mr-2 text-lg text-prime"></i>Lebih murah dan mesra alam
                            berbanding kad
                            kahwin
                            tradisional kerana ianya tidak perlu dicetak
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-check-circle mr-2 text-lg text-prime"></i>Boleh diakses oleh tetamu
                            melalui
                            mana-mana
                            peranti yang
                            mempunyai capaian internet
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-check-circle mr-2 text-lg text-prime"></i>Ciri-ciri seperti galeri gambar
                            dan musik video
                            menjadikan kad kahwin lebih menarik dan menyerlah
                        </li>
                    </ul>
                </div>
                <div>
                    <img src="{{ url('/images/demo_kkd.png') }}" class="w-full max-w-sm mx-auto">
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-4"><span
                    class="text-prime">Fungsi</span> Kad Kahwin Digital</h1>
            <p class="mb-8 text-center">
                Kad kahwin digital kami dilengkapi dengan pelbagai fungsi yang menarik
            </p>
            <div class="grid lg:grid-cols-3">
                <div class="lg:text-right h-full grid lg:grid-rows-3 gap-6 order-2 lg:order-1 pb-6 lg:pb-0 lg:pt-12">
                    <div class="flex">
                        <div
                            class="lg:order-2 w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <img src="{{ url('/images/icon_chat_ai_kkd.svg') }}" class="w-10">
                        </div>
                        <div class="lg:order-1 px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Chat AI</h1>
                            <p class="text-gray-900 mt-2">Tetamu boleh berbual dengan Chat AI untuk mendapatkan
                                maklumat
                                mengenai majlis</p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="lg:order-2 w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-book-reader"></i>
                        </div>
                        <div class="lg:order-1 px-6">
                            <h1 class="text-2xl font-bold text-gray-900">RSVP</h1>
                            <p class="text-gray-900 mt-2">Tetamu boleh menghantar status kehadiran mereka kepada pihak
                                majlis</p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="lg:order-2 w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div class="lg:order-1 px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Money Gift</h1>
                            <p class="text-gray-900 mt-2">Terima wang tanpa tunai terus ke akaun bank anda</p>
                        </div>
                    </div>
                </div>
                <div class="order-1 lg:order-2 px-12 mb-12 lg:mb-0">
                    <div class="w-full relative overflow-hidden">
                        <img src="{{ url('/images/ex_theme_5.png') }}" class="w-full">
                    </div>
                </div>
                <div class="h-full grid lg:grid-rows-3 order-3 gap-6 lg:order-3 lg:pt-12">
                    <div class="flex">
                        <div
                            class="w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fab fa-youtube"></i>
                        </div>
                        <div class="px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Video Lagu</h1>
                            <p class="text-gray-900 mt-2">Tambahkan lagu sebagai latar belakang kad kahwin anda</p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-save"></i>
                        </div>
                        <div class="px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Download PDF</h1>
                            <p class="text-gray-900 mt-2">
                                Muat turun kad kahwin anda format PDF & hantar kepada tetamu anda
                            </p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-map-marked-alt"></i>
                        </div>
                        <div class="px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Lokasi</h1>
                            <p class="text-gray-900 mt-2">Penunjuk arah menggunakan aplikasi Google Maps atau Waze</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-4">Pilihan Tema <span
                    class="text-prime">Menarik</span></h1>
            <p class="mb-8 text-center">
                Pelbagai design menarik tersedia khusus untuk anda
            </p>
            <div class="glider-contain mb-12 px-6">
                <div class="glider">
                    <div class="px-3"><img src="{{ url('images/ex_theme_1.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_7.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_2.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_3.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_6.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_4.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_5.png') }}"></div>
                </div>
                <button aria-label="Previous" class="glider-prev"
                    style="left: 0; top: 50%; transform: translateY(-50%);">«</button>
                <button aria-label="Next" class="glider-next"
                    style="right: 0; top: 50%; transform: translateY(-50%);">»</button>
            </div>
            <script type="text/javascript">
                new Glider(document.querySelector('.glider'), {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    draggable: true,
                    dots: '.dots',
                    arrows: {
                        prev: '.glider-prev',
                        next: '.glider-next'
                    }
                });
            </script>
            <div class="w-full flex justify-center">
                <a href="{{ route('theme.index') }}">
                    <x-primary-button class="flex justify-center">
                        See More Themes
                    </x-primary-button>
                </a>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-4">Apa <span
                    class="text-prime">kata</span> mereka?</h1>
            <p class="mb-8 text-center">
                Lihat bagaimana Kad Kahwin Digital melancarkan perjalanan hari raja sehari
            </p>
            <div class="grid grid-cols-1 lg:grid-cols-3 mb-12 gap-12">
                <div class="flex flex-col items-center">
                    <div class="mb-2 text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-center">Boleh edit sendiri, ada banyak design cantik... kena
                        dengan selera saya... Terbaik</p>
                    <p class="mt-2 font-semibold">Mohd Zamri</p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="mb-2 text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-center">Kawan ramai kata senang pakai KKD, tekan terus connect dengan Waze.</p>
                    <p class="mt-2 font-semibold">Sarah Hamid</p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="mb-2 text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-center">Sangat mudah dan cepat. Admin juga sangat membantu. Terima kasih.</p>
                    <p class="mt-2 font-semibold">Nurul Shafiqah</p>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8 flex flex-col items-center justify-center">
            @php
                $lastday = date('Y-m-t', strtotime(NOW()));
                $lastdate = date('d F', strtotime($lastday));
                $originalstart = date('d F', strtotime($lastday . ' +1 day'));

                $currentDate = new DateTime();
                $lastDayOfMonth = new DateTime($currentDate->format('Y-m-t'));
                $daysRemaining = $currentDate->diff($lastDayOfMonth)->format('%a');
                if($daysRemaining == 0) $daysRemaining = 1;
            @endphp
            <div class="flex flex-col lg:flex-row gap-12">
                <img src="{{ url('/images/promo_discount75.png') }}"
                    class="max-w-lg w-full aspect-square object-contain shrink-1 mx-auto">
                <div class="flex flex-col lg:items-start justify-center shrink-1 max-w-md">
                    <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center lg:text-left mb-4">Dapatkan
                        <span class="text-red-600">Sekarang!</span>
                    </h1>
                    <p class="text-center lg:text-left text-lg lg:text-2xl font-bold mb-6">
                        Sekarang promosi untuk 75% diskaun. Hanya <span class="text-green-600">RM 29</span> dari harga
                        biasa <span class="text-red-600 text-2xl lg:text-3xl line-through">RM 116</span> untuk tema
                        design pilihan anda.
                    </p>
                    <div class="grid grid-cols-1 gap-2 mb-6">
                        <div
                            class="grid lg:grid-cols-2 gap-6 p-4 rounded-xl border border-slate-200 bg-white opacity-50">
                            <div>
                                <p class="uppercase text-sm">Original Price</p>
                                <p class="text-2xl font-bold">Harga <span class="text-red-600">Original</span></p>
                                <p>Bermula Pada <span class="text-red-600 font-bold">{{ $originalstart }}</span></p>
                            </div>
                            <div class="flex items-center justify-center text-4xl font-bold pb-2 lg:pb-0">
                                <p class="flex gap-2"><i class="fas fa-lock text-red-600"></i>RM 116</p>
                            </div>
                        </div>
                        <div class="grid lg:grid-cols-2 gap-6 p-4 rounded-xl border border-slate-200 shadow bg-white">
                            <div>
                                <p class="uppercase text-sm">Limited Promotion</p>
                                <p class="text-2xl font-bold">{{ date('F') }} <span class="text-green-600">75%
                                        OFF</span>
                                </p>
                                <p><span class="text-green-600 font-bold">{{ $daysRemaining }} Hari</span> Lagi
                                    Sebelum Habis</p>
                            </div>
                            <div class="flex items-center justify-center text-4xl font-bold pb-2 lg:pb-0">
                                <p class="flex gap-2 relative">
                                    <i class="fas fa-lock-open text-green-600"></i>RM 29<sub
                                        class="font-bold line-through text-red-700 text-sm absolute -top-4 right-0">RM
                                        116</sub>
                                </p>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('theme.index') }}"
                        class="shrink-1 mx-auto lg:mx-0 flex flex-col lg:flex-row gap-4">
                        <x-danger-button class="flex justify-center">
                            BELI NANTI
                        </x-danger-button>
                        <x-success-button class="flex justify-center">
                            BELI SEKARANG
                        </x-success-button>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="w-full bg-prime flex items-center justify-center py-24 px-6 relative text-white mt-12 lg:mt-24">

        <div class="flex flex-col items-center text-center">
            <p class="mb-3 lg:text-2xl font-semibold">Tunggu apa lagi?</p>
            <h1 class="text-3xl lg:text-6xl font-bold">Jadikan Majlis Anda<br>Yang Teristimewa</h1>
            <p class="my-6">Miliki Kad Kahwin yang memudahkan tetamu anda</p>
            <a href="{{ route('theme.index') }}">
                <x-secondary-button>
                    Dapatkan Sekarang
                </x-secondary-button>
            </a>
        </div>

    </div>

</x-app-layout>
