<x-app-layout>

    <div class="pt-12 lg:pt-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-2xl lg:text-4xl font-bold text-gray-900 text-center mb-8">
                TENGAH CARI KAD KAHWIN DIGITAL YANG CANTIK & TERKINI?
                <br><span class="text-prime">ANDA DI WEBSITE YANG BETUL!</span>
            </h1>
            <div class="text-6xl flex justify-center text-prime"><i
                    class="fas fa-arrow-alt-circle-down animate-bounce"></i></div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="grid lg:grid-cols-2">
                <div>
                    <img src="{{ url('/images/example.png') }}" class="mx-auto">
                </div>
                <div class="flex flex-col justify-center pt-12 lg:pt-24">
                    <h1 class="text-2xl lg:text-4xl font-bold text-gray-900 mb-8 lg:mb-12">Kad Kahwin Digital<br>Untuk
                        <span class="text-prime">Hari Isitimewa</span> Anda
                    </h1>
                    <p class="mb-4 lg:-ml-12">
                        Dengan kad kahwin digital kami, urusan jemputan kahwin akan menjadi lebih senang dan teratur. Ia
                        juga memudahkan tetamu anda untuk mengakses dan boleh menggunakan fungsi-fungsi seperti:
                    </p>
                    <ul class="mb-4 lg:-ml-12">
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>Chat AI: Tetamu boleh
                            berbual dengan chatbot
                            untuk dapatkan maklumat majlis
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>RSVP: Tetamu boleh
                            menghantar status
                            kehadiran mereka
                            kepada pihak majlis
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>PDF: Anda boleh download
                            format PDF & hantar kepada tetamu anda
                        </li>
                        {{-- <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>Lokasi: Penunjuk arah
                            menggunakan aplikasi
                            Google Maps
                            atau Waze
                        </li>
                        <li class="flex mb-2">
                            <i class="fas fa-arrow-circle-right mr-2 text-lg text-prime"></i>Kalendar: Simpan tarikh
                            majlis sebagai
                            peringatan di
                            Google Calendar
                        </li> --}}
                    </ul>
                    <div class="w-full flex justify-center lg:-ml-12">
                        <a href="{{ route('theme.index') }}">
                            <x-primary-button class="flex justify-center">
                                Dapatkan Sekarang!
                            </x-primary-button>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-8">Apa Beza <span
                    class="text-prime">KKD</span> Dengan<br>Kad Digital Lain?
            </h1>
            <div class="bg-white rounded-xl grid lg:grid-cols-2 overflow-hidden shadow">
                <div class="flex flex-col lg:border-r">
                    <div class="bg-gray-400 text white text-2xl font-bold p-6 text-white text-center">Kad Yang Lain
                    </div>
                    <div class="flex flex-col gap-3 p-6 text-xl text-gray-400">
                        <div>
                            <i class="fas fa-star-of-life mr-1"></i> Kena Booking / Order Dulu
                        </div>
                        <div>
                            <i class="fas fa-star-of-life mr-1"></i> Tunggu Siap Dalam 3-5 Hari
                        </div>
                        <div>
                            <i class="fas fa-star-of-life mr-1"></i> Dapat Kad Digital Sahaja
                        </div>
                    </div>
                </div>
                <div class="flex flex-col">
                    <div class="bg-prime text white text-2xl font-bold p-6 text-white text-center">Kad Kahwin Digital
                        (KKD)</div>
                    <div class="flex flex-col gap-3 p-6 text-xl">
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Ada Chat AI Yang Boleh Bantu Tetamu
                            Anda
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Dapat Kad Kahwin Digital yang cantik
                            dan
                            menarik
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Kad Kahwin Digital + RSVP + QR Pay +
                            Chat AI
                            + Banyak Lagi
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Siap Dalam 10 Minit
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Tak Payah Bookking Dulu
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Boleh Edit Sendiri Bila-bila Masa
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> Boleh Download Kad Format PDF
                        </div>
                        <div>
                            <i class="fas fa-thumbs-up text-green-600 mr-1"></i> 7+ Tahun Jenama Yang Dipercayai 30K+
                            Pengguna
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <iframe src="https://www.youtube.com/embed/EpTQjhtzH2A" title="YouTube video player" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                allowfullscreen class="aspect-video w-full rounded-xl"></iframe>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="bg-white rounded-xl grid lg:grid-cols-2 overflow-hidden shadow">
                <div class="bg-prime">
                    <img src="{{ url('/images/chat_ai_demo.png') }}" class="w-full">
                </div>
                <div class="p-6 lg:p-12 flex flex-col justify-between gap-6">
                    <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-left">Kad Kahwin Digital<br> +
                        <img src="{{ url('/images/logo_chat_ai_kkd.svg') }}"
                            class="w-8 lg:w-12 inline-block rounded-full mb-2 lg:mb-3">
                        <span class="text-prime">Chat AI</span>

                    </h1>

                    <p class="lg:text-xl">
                        Kad Kahwin Digital pertama yang dilengkapi dengan Chat AI, chatbot yang boleh berbual dengan
                        tetamu anda. Ia akan memberikan maklumat mengenai majlis anda dan juga boleh menjawab
                        soalan-soalan yang sering ditanya oleh tetamu anda.
                    </p>
                    <div class="gap-6 flex flex-col" x-data="{ chat: false }">
                        <div class="flex">
                            <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden mr-3 shrink-0">
                                <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-fit">
                            </div>
                            <div class="flex-grow">
                                <p class="font-semibold text-prime">Chat AI</p>
                                <p class="">Salam, saya Chat AI. Ada apa-apa yang boleh saya bantu?</p>
                            </div>
                        </div>
                        <div class="flex" x-show="chat" x-transition.delay.500ms>
                            <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden mr-3 shrink-0">
                                <img src="{{ url('/images/chat_ai_kkd_profile_2.png') }}" class="object-fit">
                            </div>
                            <div class="flex-grow">
                                <p class="font-semibold">Guest</p>
                                <p class="">Saya nak buat kad kahwin digital yang ada Chat AI</p>
                            </div>
                        </div>
                        <div class="flex" x-show="chat" x-transition.delay.1000ms>
                            <div class="w-10 lg:w-16 h-10 lg:h-16 rounded-full overflow-hidden mr-3 shrink-0">
                                <img src="{{ url('/images/chat_ai_kkd_profile.png') }}" class="object-fit">
                            </div>
                            <div class="flex-grow">
                                <p class="font-semibold text-prime">Chat AI</p>
                                <p class="mb-4">Sila tekan butang "Mula Buat" di bawah untuk mula buat kad kahwin
                                    digital
                                    anda</p>
                                <a href="{{ route('theme.index') }}">
                                    <x-secondary-button class="flex justify-center">
                                        Mula Buat
                                    </x-secondary-button>
                                </a>
                            </div>
                        </div>
                        <div class="flex gap-3 w-full flex-col lg:flex-row" x-show="!chat" x-transition.duration.500ms>
                            <div class="flex-grow border border-gray-300 rounded-lg py-3 px-4 lg:truncate">
                                saya nak buat kad kahwin digital yang ada Chat AI
                            </div>
                            <button class="bg-green-600 text-white px-6 py-3 rounded-lg animate-pulse"
                                @click="chat = true">
                                SEND
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-4"><span
                    class="text-prime">Fungsi</span> Kad Kahwin Digital</h1>
            <p class="mb-8 text-center">
                Kad kahwin digital kami dilengkapi dengan pelbagai fungsi yang menarik
            </p>
            <div class="grid lg:grid-cols-3">
                <div class="lg:text-right h-full grid lg:grid-rows-3 gap-6 order-2 lg:order-1 pb-6 lg:pb-0 lg:pt-12">
                    <div class="flex">
                        <div
                            class="lg:order-2 w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <img src="{{ url('/images/icon_chat_ai_kkd.svg') }}" class="w-10">
                        </div>
                        <div class="lg:order-1 px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Chat AI</h1>
                            <p class="text-gray-900 mt-2">Tetamu boleh berbual dengan Chat AI untuk mendapatkan
                                maklumat
                                mengenai majlis</p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="lg:order-2 w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-book-reader"></i>
                        </div>
                        <div class="lg:order-1 px-6">
                            <h1 class="text-2xl font-bold text-gray-900">RSVP</h1>
                            <p class="text-gray-900 mt-2">Tetamu boleh menghantar status kehadiran mereka kepada pihak
                                majlis</p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="lg:order-2 w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div class="lg:order-1 px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Money Gift</h1>
                            <p class="text-gray-900 mt-2">Terima wang tanpa tunai terus ke akaun bank anda</p>
                        </div>
                    </div>
                </div>
                <div class="order-1 lg:order-2 px-12 mb-12 lg:mb-0">
                    <div class="w-full relative overflow-hidden">
                        <img src="{{ url('/images/ex_theme_5.png') }}" class="w-full">
                    </div>
                </div>
                <div class="h-full grid lg:grid-rows-3 order-3 gap-6 lg:order-3 lg:pt-12">
                    <div class="flex">
                        <div
                            class="w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fab fa-youtube"></i>
                        </div>
                        <div class="px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Video Lagu</h1>
                            <p class="text-gray-900 mt-2">Tambahkan lagu sebagai latar belakang kad kahwin anda</p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-save"></i>
                        </div>
                        <div class="px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Download PDF</h1>
                            <p class="text-gray-900 mt-2">
                                Muat turun kad kahwin anda format PDF & hantar kepada tetamu anda
                            </p>
                        </div>
                    </div>
                    <div class="flex">
                        <div
                            class="w-16 h-16 rounded-full text-white bg-prime aspect-square flex items-center justify-center text-3xl shadow min-w-max">
                            <i class="fas fa-map-marked-alt"></i>
                        </div>
                        <div class="px-6">
                            <h1 class="text-2xl font-bold text-gray-900">Lokasi</h1>
                            <p class="text-gray-900 mt-2">Penunjuk arah menggunakan aplikasi Google Maps atau Waze</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-4">Banyak Pilihan <span
                    class="text-prime">Menarik</span></h1>
            <p class="mb-8 text-center">
                Pelbagai design menarik tersedia khusus untuk anda
            </p>
            <div class="glider-contain mb-12 px-6">
                <div class="glider">
                    <div class="px-3"><img src="{{ url('images/ex_theme_1.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_7.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_2.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_3.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_6.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_4.png') }}"></div>
                    <div class="px-3"><img src="{{ url('images/ex_theme_5.png') }}"></div>
                </div>
                <button aria-label="Previous" class="glider-prev"
                    style="left: 0; top: 50%; transform: translateY(-50%);">«</button>
                <button aria-label="Next" class="glider-next"
                    style="right: 0; top: 50%; transform: translateY(-50%);">»</button>
            </div>
            <script type="text/javascript">
                new Glider(document.querySelector('.glider'), {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    draggable: true,
                    dots: '.dots',
                    arrows: {
                        prev: '.glider-prev',
                        next: '.glider-next'
                    }
                });
            </script>
            <div class="w-full flex justify-center">
                <a href="{{ route('theme.index') }}">
                    <x-primary-button class="flex justify-center">
                        Dapatkan Sekarang!
                    </x-primary-button>
                </a>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-12">7+ Tahun <span
                    class="text-prime">Dipercayai</span> Malaysia</h1>
            <div class="p-3 lg:p-6 bg-gray-800 flex justify-center rounded-xl mb-12">
                <a href="{{ url('/images/kkd_awards.png') }}" class="venobox">
                    <img src="{{ url('/images/kkd_awards.png') }}" class="w-full max-w-4xl">
                </a>
            </div>
            <div
                class="space-y-8 relative before:absolute before:inset-0 before:ml-5 before:-translate-x-px md:before:mx-auto md:before:translate-x-0 before:h-full before:w-0.5 before:bg-gradient-to-b before:from-transparent before:via-slate-300 before:to-transparent">

                <!-- Item #1 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital</div>
                            <time class="font-caveat font-medium text-prime">2016</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <img src="{{ asset('images/about/kkd_2016.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32 rounded-lg">
                            <p>
                                Bermula sebagai perkhidmatan membuat aplikasi Android sebagai alternatif kad kahwin
                                tradisional. Membentuk batu asas untuk kad kahwin digital dengan fungsi navigasi ke
                                lokasi & imbas QR Code.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            <a href="{{ asset('images/about/2016/slide2.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2016/slide2.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2016/slide3.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2016/slide3.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2016/slide4.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2016/slide4.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #2 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital Micro</div>
                            <time class="font-caveat font-medium text-prime">2017</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <img src="{{ asset('images/about/kkd_2017.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32">
                            <p>
                                Buat pertama kalinya, kad kahwin digital menjadi versi web. Pengguna boleh daftar akaun
                                & buat kad kahwin digital mereka sendiri secara percuma. Memperkenalkan fungsi
                                peringatan majlis di kalendar Google. Warna tema juga telah ditukar dari oren ke biru.
                            </p>
                        </div>
                        <div class="grid grid-cols-1 mt-4">
                            <iframe src="https://www.youtube.com/embed/VzhBmqBRsBw" title="YouTube video player"
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                allowfullscreen class="aspect-video w-full"></iframe>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            <a href="{{ asset('images/about/2017/slide1.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2017/slide1.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2017/slide2.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2017/slide2.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2017/slide3.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2017/slide3.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #3 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">KadKahwinDigital.my</div>
                            <time class="font-caveat font-medium text-prime">2019</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <img src="{{ asset('images/about/kkd_2019.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32 rounded-lg">
                            <p>
                                Dilancarkan sebagai platform web untuk memudahkan pengguna membuat kad kahwin digital
                                mereka sendiri. Membawakan fungsi galeri gambar, video lagu dari YouTube & reka bentuk
                                sistem yang lebih mesra pengguna. Logo baru juga diperkenalkan untuk memberikan imej
                                yang lebih moden.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            {{-- <div>
                                <img src="{{ asset('images/about/2019/slide1.jpg') }}" alt="Kad Kahwin Digital" class="w-full rounded-lg shadow">
                            </div> --}}
                            <a href="{{ asset('images/about/2019/slide2.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2019/slide2.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2019/slide3.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2019/slide3.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2019/slide4.jpg') }}" class="venobox">
                                <img src="{{ asset('images/about/2019/slide4.jpg') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #4 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group is-active">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-slate-300 group-[.is-active]:bg-emerald-500 text-slate-500 group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">PKP (Covid-19)</div>
                            <time class="font-caveat font-medium text-prime">2020</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            {{-- <img src="{{ asset('images/about/kkd_chat_ai_2023.png') }}" alt="Kad Kahwin Digital"
                                class="w-24 h-24 lg:w-32 lg:h-32 rounded-lg"> --}}
                            <p>
                                Dengan adanya PKP, kami memperkenalkan fungsi RSVP untuk memudahkan pengantin
                                menguruskan senarai tetamu hadir. Fungsi reaksi emoji juga ditambah bagi membolehkan
                                tetamu menunjukan tanda mereka meraikan pengantin.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 lg:grid-cols-3 gap-2 mt-4">
                            <a href="{{ asset('images/about/2020/slide1.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2020/slide1.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2020/slide2.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2020/slide2.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                            <a href="{{ asset('images/about/2020/slide3.png') }}" class="venobox">
                                <img src="{{ asset('images/about/2020/slide3.png') }}" alt="Kad Kahwin Digital"
                                    class="w-full rounded-lg shadow">
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Item #5 -->
                <div
                    class="relative flex items-center justify-between md:justify-normal md:odd:flex-row-reverse group">
                    <!-- Icon -->
                    <div
                        class="flex items-center justify-center w-10 h-10 rounded-full border border-white bg-prime group-[.is-active]:bg-emerald-500 text-white group-[.is-active]:text-emerald-50 shadow shrink-0 md:order-1 md:group-odd:-translate-x-1/2 md:group-even:translate-x-1/2">
                        <i class="fas fa-star"></i>
                    </div>
                    <!-- Card -->
                    <div
                        class="w-[calc(100%-4rem)] md:w-[calc(50%-2.5rem)] bg-white p-4 rounded-xl border border-slate-200 shadow">
                        <div class="flex items-center justify-between space-x-2 mb-1">
                            <div class="font-bold text-slate-900">Kad Kahwin Digital + Chat AI</div>
                            <time class="font-caveat font-medium text-prime">2023</time>
                        </div>
                        <div class="text-slate-500 flex flex-col lg:flex-row gap-4 mt-4">
                            <div class="relative w-24 h-24 lg:w-32 lg:h-32 shrink-0">
                                <img src="{{ asset('images/about/kkd_2019.png') }}" alt="Kad Kahwin Digital"
                                    class="absolute top-0 left-0 w-20 h-20 lg:w-28 lg:h-28 rounded-lg">
                                <img src="{{ asset('images/about/kkd_chat_ai_2023.png') }}" alt="Kad Kahwin Digital"
                                    class="absolute bottom-0 right-0 w-8 h-8 lg:w-12 lg:h-12 rounded-lg">
                            </div>
                            <p>
                                Naik taraf terkini untuk Kad Kahwin Digital. Seluruh sistem dibangunkan semula dengan
                                menggunakan teknologi terkini. Fungsi Chat AI juga ditambah bagi membolehkan tetamu
                                mendapatkan maklumat terkini mengenai majlis.
                            </p>
                        </div>
                        <div class="grid grid-cols-1 mt-4">
                            <iframe src="https://www.youtube.com/embed/EpTQjhtzH2A" title="YouTube video player"
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                allowfullscreen class="aspect-video w-full"></iframe>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center mb-4">Apa <span
                    class="text-prime">kata</span> mereka?</h1>
            <p class="mb-8 text-center">
                Lihat bagaimana Kad Kahwin Digital melancarkan perjalanan hari raja sehari
            </p>
            <div class="grid grid-cols-1 lg:grid-cols-3 mb-12 gap-12">
                <div class="flex flex-col items-center">
                    <div class="mb-2 text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-center">Boleh edit sendiri, ada banyak design cantik... kena
                        dengan selera saya... Terbaik</p>
                    <p class="mt-2 font-semibold">Mohd Zamri</p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="mb-2 text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-center">Kawan ramai kata senang pakai KKD, tekan terus connect dengan Waze.</p>
                    <p class="mt-2 font-semibold">Sarah Hamid</p>
                </div>
                <div class="flex flex-col items-center">
                    <div class="mb-2 text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-center">Sangat mudah dan cepat. Admin juga sangat membantu. Terima kasih.</p>
                    <p class="mt-2 font-semibold">Nurul Shafiqah</p>
                </div>
            </div>
        </div>
    </div>

    <div class="py-12 lg:py-24">
        <div class="max-w-7xl mx-auto px-6 lg:px-8 flex flex-col items-center justify-center">
            @php
                $lastday = date('Y-m-t', strtotime(NOW()));
                $lastdate = date('d F', strtotime($lastday));
                $originalstart = date('d F', strtotime($lastday . ' +1 day'));

                $currentDate = new DateTime();
                $lastDayOfMonth = new DateTime($currentDate->format('Y-m-t'));
                $daysRemaining = $currentDate->diff($lastDayOfMonth)->format('%a');
                if($daysRemaining == 0) $daysRemaining = 1;
            @endphp
            <div class="flex flex-col lg:flex-row gap-12">
                <img src="{{ url('/images/promo_discount75.png') }}"
                    class="max-w-lg w-full aspect-square object-contain shrink-1 mx-auto">
                <div class="flex flex-col lg:items-start justify-center shrink-1 max-w-md">
                    <h1 class="text-3xl lg:text-6xl font-bold text-gray-900 text-center lg:text-left mb-4">Dapatkan
                        <span class="text-red-600">Sekarang!</span>
                    </h1>
                    <p class="text-center lg:text-left text-lg lg:text-2xl font-bold mb-6">
                        Sekarang promosi untuk 75% diskaun. Hanya <span class="text-green-600">RM 29</span> dari harga
                        biasa <span class="text-red-600 text-2xl lg:text-3xl line-through">RM 116</span> untuk tema
                        design pilihan anda.
                    </p>
                    <div class="grid grid-cols-1 gap-2 mb-6">
                        <div
                            class="grid lg:grid-cols-2 gap-6 p-4 rounded-xl border border-slate-200 bg-white opacity-50">
                            <div>
                                <p class="uppercase text-sm">Original Price</p>
                                <p class="text-2xl font-bold">Harga <span class="text-red-600">Original</span></p>
                                <p>Bermula Pada <span class="text-red-600 font-bold">{{ $originalstart }}</span></p>
                            </div>
                            <div class="flex items-center justify-center text-4xl font-bold pb-2 lg:pb-0">
                                <p class="flex gap-2"><i class="fas fa-lock text-red-600"></i>RM 116</p>
                            </div>
                        </div>
                        <div class="grid lg:grid-cols-2 gap-6 p-4 rounded-xl border border-slate-200 shadow bg-white">
                            <div>
                                <p class="uppercase text-sm">Limited Promotion</p>
                                <p class="text-2xl font-bold">{{ date('F') }} <span class="text-green-600">75%
                                        OFF</span>
                                </p>
                                <p><span class="text-green-600 font-bold">{{ $daysRemaining }} Hari</span> Lagi
                                    Sebelum Habis</p>
                            </div>
                            <div class="flex items-center justify-center text-4xl font-bold pb-2 lg:pb-0">
                                <p class="flex gap-2 relative">
                                    <i class="fas fa-lock-open text-green-600"></i>RM 29<sub
                                        class="font-bold line-through text-red-700 text-sm absolute -top-4 right-0">RM
                                        116</sub>
                                </p>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('theme.index') }}"
                        class="shrink-1 mx-auto lg:mx-0 flex flex-col lg:flex-row gap-4">
                        <x-danger-button class="flex justify-center">
                            BELI NANTI
                        </x-danger-button>
                        <x-success-button class="flex justify-center">
                            BELI SEKARANG
                        </x-success-button>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="w-full bg-prime flex items-center justify-center py-24 px-6 relative text-white mt-12 lg:mt-24">

        <div class="flex flex-col items-center text-center">
            <p class="mb-3 lg:text-2xl font-semibold">Tunggu apa lagi?</p>
            <h1 class="text-3xl lg:text-6xl font-bold">Jadikan Majlis Anda<br>Yang Teristimewa</h1>
            <p class="my-6 text-xl">Miliki Kad Kahwin Yang Menambah <br>KEISTIMEWAAN Hari Bahagia Anda</p>
            <a href="{{ route('theme.index') }}">
                <x-secondary-button>
                    Dapatkan Sekarang!
                </x-secondary-button>
            </a>
        </div>

    </div>

</x-app-layout>
