<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description"
        content="Dapatkan jemputan kad kahwin digital PERCUMA! Tak perlu bayar terlebih dahulu, tak perlu membuat tempahan dahulu! Edit bila-bila masa anda mahu! Tambahan pula, ia dilengkapi dengan fungsi Chat AI.">
    <meta name="author" content="Kad Kahwin Digital">
    <meta name="keywords"
        content="kad kahwin digital percuma, kad, kahwin, digital, malaysia, e-kad, e-card, kad kahwin, murah, malaysia, johor, melaka, pahang, brunei, indonesia, penang, pulau pinang, kedah, perak, perlis, sabah, sarawak, kelantan, terengganu, selangor, kuala lumpur, kl, jb, p.pinang, kkd, design, theme, design lawo, kad kahwin, kad kawin, kad lawo, go paperless, digital wedding card, kad kahwin digital, kad kawin digital, rethink invitation, aliveinvite, kadlawo, kadlawo aliveinvite, alive invite, kad digital aliveinvite, aliveinvite digital card, digital kad, kad cantik, kad murah, kad kahwin murah, nikah, perkahwinan, kad kahwin jimat, ikrizainvite, ikriza invite, undangan, hantaran, melayu, malay, wedding, kad undangan, kad kahwin online, kad kahwin atas talian, jemputan, kad jemputan, kad kahwin percuma, KadKahwinDigital.my, alaf baru, kad kahwin digital free, kad kahwin digital invite, contoh kad kahwin digital, cara buat kad kahwin digital, kad kahwin digital micro, e-kad kahwin percuma, cara buat e kad kahwin, kad kahwin digital percuma, kad kahwin design, kad kahwin murah dan cantik, pakej kad kahwin murah, kad kahwin, contoh kad kahwin, design kad kahwin, kad kahwin murah bangi, jemputan, jemputan.me, kad, kahwin, undangan, invitation, wedding, aqiqah, birthday, hari jadi, party, parti, raya, aidilfitri, card, murah, cheap, digital, kad kahwin, kad kawin, kad lawo, go paperless, digital wedding card, kad kahwin digital, kad kawin digital, kad kahwin murah, kad jemputan kahwin, rethink invitation, kahwinnow, kad digital kahwinnow, kahwinnow digital card, digital kad, digital invitation, kad kahwin digital, kad digital, digital invitation card, cara buat kad kahwin digital, digital card wedding, e invitation card, ecard invitation, kad jemputan digital, online editable wedding invitation cards free download, digital wedding card, ecard invitation, kad kawin digital, cara buat kad jemputan digital, kad digital kahwin, kad jemputan kahwin digital free, wedding card digital, wedding invitation cards online, digital kad kahwin, digital wedding invitations free, the kahwin, thekahwin, thekahwinmy, kad aqiqah digital, kad aqiqah, kad birthday digital, kahwinnow.com, thekahwin.my, artificial intelligence, ai, chat, ai chat, kad kahwin ai, kad kahwin pintar, kad kahwin smart">

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-LCBDTMKX5Q"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-LCBDTMKX5Q');
    </script>

    <meta property="fb:app_id" content="2483405795062845" />

    <!--Open Graph Metatag-->
    <meta property="og:type" content="website" />
    <meta property="og:title" content="KadKahwinDigital.my" />
    <meta property="og:description"
        content="Dapatkan jemputan kad kahwin digital PERCUMA! Tak perlu bayar terlebih dahulu, tak perlu membuat tempahan dahulu! Edit bila-bila masa anda mahu! Tambahan pula, ia dilengkapi dengan fungsi Chat AI.">
    <meta property="og:image" content="{{ url('/images/kkd-preview.png') }}" />
    <meta property="og:image:width" content="256" />
    <meta property="og:image:height" content="256" />
    <meta property="og:image:alt" content="Kad Kahwin Digital" />
    <meta property="og:url" content="{{ url()->current() }}" />

    <!-- Chrome, Firefox OS and Opera -->
    <meta name="theme-color" content="#2dc8ff">
    <!-- Windows Phone -->
    <meta name="msapplication-navbutton-color" content="#2dc8ff">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#2dc8ff">

    <title>{{ config('app.name', 'Kad Kahwin Digital') }}</title>

    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('/images/apple-touch-icon.png') }}">
    <link rel="shortcut icon" href="{{ url('/favicon.ico') }}" type="image/x-icon">

    <!-- Fonts -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.2/css/all.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/venobox@2.0.4/dist/venobox.min.css" type="text/css"
        media="screen" />

    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    {{-- @wireUiScripts --}}
    <script src="//unpkg.com/alpinejs" defer></script>
    <script src="https://code.jquery.com/jquery-2.2.4.min.js"
        integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44=" crossorigin="anonymous"></script>

    <!-- Scripts -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2dc8ff',
                        prime: '#00aae6',
                    }
                }
            },
            darkMode: 'class',
        }
    </script>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <!-- A-Frame -->
    <script src="https://aframe.io/releases/1.7.0/aframe.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/c-frame/aframe-extras@7.4.0/dist/aframe-extras.min.js"></script>

    <!-- Glider -->
    <script src="https://cdn.jsdelivr.net/npm/glider-js@1.7.8/glider.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/glider-js@1.7.8/glider.min.css" rel="stylesheet">

</head>

<body class="antialiased">

    <div class="min-h-screen bg-gray-100 dark:bg-gray-900 flex flex-col">
        @include('layouts.navigation')

        @php
            $class = Route::currentRouteName() == 'home.index' ? 'lg:h-16' : 'h-16';
        @endphp

        <div class="{{ $class }} w-full"></div>

        <!-- Page Heading -->
        @if (isset($header))
            <header class="bg-white dark:bg-gray-800 shadow">
                <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                    {{ $header }}
                </div>
            </header>
        @endif

        <!-- Page Content -->
        <main class="flex-grow">
            {{ $slot }}
        </main>

        @include('layouts.footer')
    </div>

    <div class="w-screen h-screen bg-white flex items-center justify-center z-20 top-0 left-0 fixed" id="loading">
        <img src="{{ url('/images/icon_chat_ai_kkd.svg') }}" alt="Loading..." class="w-20 h-20 rounded-full animate-spin bg-primary p-4" />
    </div>

    <script language="javascript" type="text/javascript">
        $(window).load(function() {
            $('#loading').hide();
        });
        AOS.init();
        window.addEventListener("DOMContentLoaded", function() {
            new VenoBox({
                selector: ".venobox"
            });
        });
    </script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/venobox@2.0.4/dist/venobox.min.js"></script>

</body>

</html>
