<div class="flex flex-col max-w-sm w-full">
    <div class="px-4 py-2 text-center bg-prime text-white w-full">Nyatakan Kehadiran Anda</div>
    {{-- <div class="px-4 py-2 text-xs bg-red-200 text-red-800 w-full">Untuk mematuhi SOP majlis perkahwinan, tetamu
        diminta menjawab RSVP untuk tujuan rekod kehadiran dan
        menyusun slot masa kedatangan.</div> --}}
    <div class="p-4 w-full relative">
        @guest
            <div class="absolute bg-gray-800 bg-opacity-70 w-full h-full top-0 left-0 flex items-center justify-center backdrop-blur-sm p-8">
                <div class="grid grid-cols-1 w-full gap-4 text-center">
                    <p class="text-white mb-4">Sila log masuk untuk daftar kehadiran</p>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'facebook') }}'">
                        <i class="fab fa-facebook mr-2"></i>Facebook
                    </x-secondary-button>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'twitter') }}'">
                        <i class="fab fa-twitter mr-2"></i>Twitter
                    </x-secondary-button>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'google') }}'">
                        <i class="fab fa-google mr-2"></i>Google
                    </x-secondary-button>
                </div>
            </div>
        @endguest
        <p class="text-sm">Nama</p>
        <input class="mb-4 p-2 bg-gray-100 w-full rounded-lg" type="text" wire:model="name" required />
        <p class="text-sm">No Telefon</p>
        <input class="mb-4 p-2 bg-gray-100 w-full rounded-lg" type="tel" wire:model="phone_no" required />
        <p class="text-sm">Jumlah Hadir</p>
        <input class="mb-4 p-2 bg-gray-100 w-full rounded-lg" type="number" wire:model="people_no" required />
        <p class="text-sm">Slot Masa</p>
        <select class="mb-4 p-2 bg-gray-100 w-full rounded-lg" name="timeslots" wire:model="timeslots" id="timeslots"
            required>
            @if ($card->rsvp_timeslots != null)
                @if ($card->isOldFormatRSVP())
                    {{-- START::OLD FORMAT --}}
                    @if ($card->rsvp_timeslots['timeslot_1'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '10:00am - 11:00am') selected @endif
                            @endif>10:00am - 11:00am</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_2'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '11:00am - 12:00pm') selected @endif
                            @endif>11:00am - 12:00pm</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_3'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '12:00pm - 01:00pm') selected @endif
                            @endif>12:00pm - 01:00pm</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_4'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '01:00pm - 02:00pm') selected @endif
                            @endif>01:00pm - 02:00pm</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_5'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '02:00pm - 03:00pm') selected @endif
                            @endif>02:00pm - 03:00pm</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_6'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '03:00pm - 04:00pm') selected @endif
                            @endif>03:00pm - 04:00pm</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_7'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '04:00pm - 05:00pm') selected @endif
                            @endif>04:00pm - 05:00pm</option>
                    @endif
                    @if ($card->rsvp_timeslots['timeslot_8'] == 'on')
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == '05:00pm - 06:00pm') selected @endif
                            @endif>05:00pm - 06:00pm</option>
                    @endif
                    {{-- END::OLD FORMAT --}}
                @else
                    {{-- START::NEW FORMAT --}}
                    <option>Please Select</option>
                    @foreach ($card->rsvp_timeslots as $timeslot)
                        @if ($timeslot['data']['on'] == true)
                            <option
                                @if (isset($card->attendee)) @if ($card->attendee->timeslots == $timeslot['data']['timeslot']) selected @endif
                                @endif>
                                {{ $timeslot['data']['timeslot'] }}
                            </option>
                        @endif
                    @endforeach
                    {{-- END::NEW FORMAT --}}
                @endif
            @endif
        </select>
        <button type="button"
            class="py-3 px-6 bg-gray-800 hover:bg-gray-900 rounded-lg w-full text-center mt-4 text-white"
            wire:click="save">
            @if (isset($name)) KEMASKINI
            @else
                HADIR @endif
        </button>
    </div>
</div>
