<section>

    <style type="text/css">
        @font-face {
            font-family: "Primary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_primary }}");
        }

        @font-face {
            font-family: "Secondary";
            src: url("{{ url('/theme/fonts') }}/{{ $card->theme->font_secondary }}");
        }

        body {
            font-family: "Outfit";
        }

        .design-page {
            color: {{ $card->theme->color }};
        }

        .design-text-primary {
            font-family: "Primary";
            text-transform: {{ $card->theme->style_primary }};
        }

        .design-text-secondary {
            font-family: "Secondary";
        }
    </style>

    <script type="text/javascript">
        // Set the date we're counting down to
        var countDownDate = new Date("{{ $card->date_masihi }}").getTime();

        // Update the count down every 1 second
        var x = setInterval(function() {

            // Get today's date and time
            var now = new Date().getTime();

            // Find the distance between now and the count down date
            var distance = countDownDate - now;

            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element
            document.getElementById("text_days").innerHTML = days;
            document.getElementById("text_hours").innerHTML = hours;
            document.getElementById("text_seconds").innerHTML = seconds;
            document.getElementById("text_seconds").innerHTML = seconds;

            // If the count down is over, write some text
            if (distance < 0) {
                clearInterval(x);
                document.getElementById("countdown-block").innerHTML = "EXPIRED";
            }
        }, 1000);
    </script>

    <div class="w-full h-12">
        <div class="fixed w-full flex justify-center bg-gray-900 h-12 z-10">
            <div wire:click="changeCard"
                class="w-16 h-16 bg-white border-8 flex items-center text-3xl justify-center text-gray-900 border-gray-900 rounded-full mx-auto cursor-pointer mt-4 hover:bg-gray-200">
                <i class="fas fa-sync"></i>
            </div>
        </div>
    </div>

    <div
        class="max-w-sm mx-auto bg-gray-100 w-full flex items-center justify-center shadow-lg border-b border-gray-200 design-text-secondary design-page">
        <img src="{{ url('/theme') }}/{{ $card->theme->code }}/bg_primary.jpg" class="w-full" />
        <div class="flex flex-col items-center absolute max-w-xs w-full px-6">
            <p class="mb-6">
                @if ($card->title != null)
                    {{ $card->title }}
                @else
                    WALIMATULURUS
                @endif
            </p>
            <h1 class="text-4xl design-text-primary text-center">{{ $card->male_short_name }}</h1>
            <p>&</p>
            <h1 class="text-4xl design-text-primary text-center">{{ $card->female_short_name }}</h1>
            <h3 class="mt-6 text-xl">{{ date('d/m/Y', strtotime($card->date_masihi)) }}</h3>
            <h4 class="mb-6">{{ $card->date_hijrah }}</h4>
            <h3 class="text-xl text-center">
                {{ $card->location_name }}
            </h3>
        </div>
    </div>

    <div
        class="max-w-sm mx-auto bg-white w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary">
        <p class="mb-12">Assalamualaikum w.b.t</p>
        <h2 class="text-xl design-text-primary">{{ $card->father_name }}</h2>
        @if ($card->mother_name != '' && $card->mother_name != null && $card->father_name != '' && $card->father_name != null)
            <p>&amp;</p>
        @endif
        <h2 class="text-xl design-text-primary">{{ $card->mother_name }}</h2>
        <p class="my-4 text-sm">
            DENGAN SEGALA HORMATNYA MEMPERSILAKAN Y.B. / Y.BHG. TAN SRI / PUAN SRI /
            DATUK / DATO’/ DATIN / TUAN / PUAN / SAUDARA / SAUDARI KE MAJLIS
            PERKAHWINAN
        </p>
        <h2 class="text-xl design-text-primary">{{ $card->male_full_name }}</h2>
        <p>&amp;</p>
        <h2 class="text-xl design-text-primary">{{ $card->female_full_name }}</h2>
        <div class="mt-12 flex flex-col">
            <h6 class="font-bold">TEMPAT</h6>
            <p class="mb-4">
                {{ $card->location_address }}
            </p>
            <h6 class="font-bold">TARIKH</h6>
            <p class="mb-4">{{ date('d M Y', strtotime($card->date_masihi)) }}</p>
            <h6 class="font-bold">MASA</h6>
            <p class="mb-4">{{ $card->time_start }} - {{ $card->time_end }}</p>
        </div>
    </div>

    <div
        class="max-w-sm mx-auto bg-gray-100 w-full flex items-center justify-center shadow-lg border-b border-gray-200 design-text-secondary design-page">
        <img src="{{ url('/theme') }}/{{ $card->theme->code }}/bg_secondary.jpg" class="w-full" />
        <div class="flex flex-col items-center absolute max-w-xs w-full px-6">
            <h2 class="text-xl mb-12">ATURCARA</h2>
            <table class="table table-borderless"
                style="color: {{ $card->theme->color }}; width: fit-content ;margin: 0 auto;">
                <tbody>
                    <tr>
                        <td class="text-right pb-8">{{ $card->program_time_1 }}</td>
                        <td class="pl-8 pb-8">{{ $card->program_name_1 }}</td>
                    </tr>
                    <tr>
                        <td class="text-right pb-8">{{ $card->program_time_2 }}</td>
                        <td class="pl-8 pb-8">{{ $card->program_name_2 }}</td>
                    </tr>
                    <tr>
                        <td class="text-right">{{ $card->program_time_3 }}</td>
                        <td class="pl-8">{{ $card->program_name_3 }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div
        class="max-w-sm mx-auto bg-white w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary">
        <p class="text-sm mb-6">
            "Ya Allah Yang Maha Mencipta, Jadikanlah majlis ini majlis yang mendapat
            keberkatan dan keredhaanMu, kekalkanlah ikatan perkahwinan mereka
            sepanjang hayat, tetapkanlah kasih sayang antara mereka selagi tidak
            melebihi kasih padaMu."
        </p>
        <p class="text-sm">Aamin, Ya Rabbal A'lamin</p>
    </div>

    <div
        class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white">
        <h2 class="text-xl mb-12">COUNTDOWN</h2>
        @php
            $count_date = explode('-', $card->date_masihi);
        @endphp
        <div class="grid grid-cols-4 w-full" id="countdown-block">
            <big><span id="text_days">0</span></big>
            <big><span id="text_hours">0</span></big>
            <big><span id="text_minutes">0</span></big>
            <big><span id="text_seconds">0</span></big>
            <span><small>Hari</small></span>
            <span><small>Jam</small></span>
            <span><small>Minit</small></span>
            <span><small>Saat</small></span>
        </div>
    </div>

    <div
        class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white">
        <h2 class="text-xl mb-12">GALLERY</h2>

    </div>

    @if ($card->youtube_url != null || $card->youtube_url != '')
        <div
            class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200 design-text-secondary bg-white">
            <h2 class="text-xl mb-12">VIDEO LAGU</h2>
            <iframe class="w-full aspect-video rounded-lg overflow-hidden" src="{{ $card->youtube_url }}?autoplay=1"
                frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen></iframe>
        </div>
    @endif

    <div
        class="max-w-sm mx-auto bg-gray-100 w-full flex items-center flex-col text-center shadow-lg py-16 px-4 border-b border-gray-200  bg-white">
        <p class="mb-2 text-xs font-bold">POWERED BY</p>
        <a href="https://app.kadkahwindigital.my/">
            <img src="{{ url('/images/navbar_brand.svg') }}" class="w-full h-12" />
        </a>
        <p class="my-4">Follow Us</p>
        <div class="grid grid-cols-3 text-4xl gap-8">
            <a href="https://www.facebook.com/kadkahwindigital" target="_blank">
                <i class="fab fa-facebook"></i>
            </a>
            <a href="https://twitter.com/kaddigital" target="_blank">
                <i class="fab fa-twitter"></i>
            </a>
            <a href="https://www.instagram.com/kadkahwindigital.my/" target="_blank">
                <i class="fab fa-instagram"></i>
            </a>
        </div>
    </div>

    <div class="w-full h-16"></div>

    <div class="fixed w-full bg-gray-900 z-10 bottom-0">
        <div class="h-16 max-w-sm mx-auto grid grid-cols-3 text-white">
            <div id="btn_calendar" class="flex items-center justify-center flex-col hover:bg-black cursor-pointer">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <p class="text-xs">Calendar</p>
            </div>
            <div id="btn_location" class="flex items-center justify-center flex-col hover:bg-black cursor-pointer">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-map-marked-alt"></i>
                </div>
                <p class="text-xs">Location</p>
            </div>
            <div id="btn_contacts" class="flex items-center justify-center flex-col hover:bg-black cursor-pointer">
                <div class="mb-2 w-4 h-4 text-white">
                    <i class="fas fa-phone"></i>
                </div>
                <p class="text-xs">Contacts</p>
            </div>
        </div>
    </div>

    <div
        class="hidden fixed kkd-backdrop w-full h-full bg-gray-800 bg-opacity-90 top-0 z-20 flex flex-col justify-end px-4">
        <div id="modal_calendar"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            <h1 class="text-3xl font-bold">{{ $card->date_masihi }}</h1>
            <h6 class="mb-4">{{ $card->time_start }} - {{ $card->time_end }}</h6>
            @php
                $event_date = str_replace('-', '', $card->date_masihi);
                $event_start = str_replace(':', '', $card->time_start);
                $event_end = str_replace(':', '', $card->time_end);
            @endphp
            <button type="button" class="p-4 bg-gray-200 hover:bg-gray-300 rounded-lg w-full text-center"
                onclick="window.open('https://calendar.google.com/calendar/r/eventedit?text={{ $card->male_full_name }}+%26+{{ $card->female_full_name }}&dates={{ $event_date }}T{{ $event_start }}00%2F{{ $event_date }}T{{ $event_end }}00&details={{ $card->male_full_name }}+%26+{{ $card->female_full_name }}%0A%0AAlamat+%3A2%2C+{{ $card->location_address }}&location={{ $card->location_name }}&sf=true&output=xml', '_blank')">
                <i class="fas fa-calendar-plus mr-2"></i>Add to Calendar
            </button>
        </div>

        <div id="modal_location"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center hidden">
            <h6 class="mb-4 text-xl">Dewan Serbaguna Perkampungan Juru</h6>
            <div class="grid grid-cols-2 w-full">
                <a href="https://maps.google.com/maps?daddr={{ $card->location_map_url }}&navigate=yes"
                    class="p-4 bg-gray-200 hover:bg-gray-300 rounded-l-lg w-full text-center">
                    <i class="fas fa-map-marker-alt mr-2"></i>Maps
                </a>
                <a href="https://waze.com/ul?q={{ $card->location_map_url }}&navigate=yes&zoom=17"
                    class="p-4 bg-gray-200 hover:bg-gray-300 rounded-r-lg w-full text-center">
                    <i class="fab fa-waze mr-2"></i>Waze
                </a>
            </div>
        </div>

        <div id="modal_contacts"
            class="max-w-sm w-full rounded-2xl p-4 bg-white mx-auto mb-8 shadow-lg flex flex-col items-center space-y-4 hidden">
            <div class="flex items-center w-full">
                <p class="flex-grow text-xl">
                    <i class="fas fa-user-circle mr-2"></i>{{ $card->contact_name_1 }}
                </p>
                <div class="grid grid-cols-2 text-xl">
                    <a href="tel:{{ $card->contact_phone_1 }}"
                        class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-l-lg flex items-center justify-center">
                        <i class="fas fa-phone"></i>
                    </a>
                    <a href="https://wa.me/6{{ $card->contact_phone_1 }}"
                        class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-r-lg flex items-center justify-center">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>
            </div>
            <div class="flex items-center w-full">
                <p class="flex-grow text-xl">
                    <i class="fas fa-user-circle mr-2"></i>{{ $card->contact_name_2 }}
                </p>
                <div class="grid grid-cols-2 text-xl">
                    <a href="tel:{{ $card->contact_phone_2 }}"
                        class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-l-lg flex items-center justify-center">
                        <i class="fas fa-phone"></i>
                    </a>
                    <a href="https://wa.me/6{{ $card->contact_phone_2 }}"
                        class="w-12 h-12 bg-gray-200 hover:bg-gray-300 rounded-r-lg flex items-center justify-center">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>
            </div>
        </div>

        <div id="btn_close"
            class="w-12 h-12 bg-red-600 border-2 flex items-center justify-center text-white border-white rounded-full shadow-lg mb-2 mx-auto cursor-pointer hover:bg-red-500">
            🞫
        </div>

        <p class="text-white mx-auto mb-4 text-xs uppercase">Close</p>
    </div>

    <script>
        $("#btn_calendar").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_calendar").toggleClass("hidden");
        });
        $("#btn_location").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_location").toggleClass("hidden");
        });
        $("#btn_contacts").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_contacts").toggleClass("hidden");
        });
        $("#btn_close").click(function() {
            $(".kkd-backdrop").toggleClass("hidden");
            $("#modal_calendar").addClass("hidden");
            $("#modal_location").addClass("hidden");
            $("#modal_contacts").addClass("hidden");
        });
    </script>

    <script>
        AOS.init();
    </script>

</section>
