<div class="flex flex-col max-w-sm w-full">
    <div class="px-4 py-2 text-center bg-prime text-white w-full">My Attendances</div>
    <div class="p-4 w-full relative">
        @guest
            <div
                class="absolute bg-gray-800 bg-opacity-70 w-full h-full top-0 left-0 flex items-center justify-center backdrop-blur-sm p-8">
                <div class="grid grid-cols-1 w-full gap-4 text-center">
                    <p class="text-white mb-4">Please login to record your attendance</p>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'facebook') }}'">
                        <i class="fab fa-facebook mr-2"></i>Facebook
                    </x-secondary-button>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'twitter') }}'">
                        <i class="fab fa-twitter mr-2"></i>Twitter
                    </x-secondary-button>
                    <x-secondary-button type="button" class="justify-center"
                        onclick="location.href='{{ route('social.login', 'google') }}'">
                        <i class="fab fa-google mr-2"></i>Google
                    </x-secondary-button>
                </div>
            </div>
        @endguest
        <p class="text-sm">Name</p>
        <input class="mb-4 p-2 bg-gray-100 w-full rounded-lg" type="text" wire:model="name" required />
        <p class="text-sm">Phone No</p>
        <input class="mb-4 p-2 bg-gray-100 w-full rounded-lg" type="tel" wire:model="phone_no" required />
        <p class="text-sm">Number of Pax</p>
        <input class="mb-4 p-2 bg-gray-100 w-full rounded-lg" type="number" wire:model="people_no" required />
        <p class="text-sm">Timeslot</p>
        <select class="mb-4 p-2 bg-gray-100 w-full rounded-lg" name="timeslots" wire:model="timeslots" id="timeslots"
            required>
            @if ($card->rsvp_timeslots != null)
                <option>Please Select</option>
                @foreach ($card->rsvp_timeslots as $timeslot)
                    @if ($timeslot['data']['on'] == true)
                        <option @if (isset($card->attendee)) @if ($card->attendee->timeslots == $timeslot['data']['timeslot']) selected @endif
                            @endif>
                            {{ $timeslot['data']['timeslot'] }}
                        </option>
                    @endif
                @endforeach
            @endif
        </select>
        <button type="button"
            class="py-3 px-6 bg-gray-800 hover:bg-gray-900 rounded-lg w-full text-center mt-4 text-white"
            wire:click="save">
            @if (isset($name)) UPDATE
            @else
                ATTEND @endif
        </button>
    </div>
</div>
