<div class="px-6 lg:px-0">

    <h1 class="text-lg font-bold text-gray-900 mb-6">
        Borang Order Printing
    </h1>

    <form class="grid lg:grid-cols-2 gap-3 lg:gap-6 bg-white shadow p-6 rounded-lg" method="post" onsubmit="submitPay(); return false;">
        <div class="flex flex-col gap-3">
            <div class="flex flex-col">
                <p class="text-sm font-medium text-slate-500">Nama</p>
                <input type="text" class="mt-2 w-full rounded-lg border px-3 py-2" wire:model="name" name="customer_name" id="customer_name">
            </div>
            <div class="flex flex-col">
                <p class="text-sm font-medium text-slate-500">Email</p>
                <input type="text" class="mt-2 w-full rounded-lg border px-3 py-2" wire:model="email" name="email" id="email">
            </div>
            <div class="flex flex-col">
                <p class="text-sm font-medium text-slate-500">Telefon</p>
                <input type="text" class="mt-2 w-full rounded-lg border px-3 py-2" wire:model="phone_no" name="phone_no" id="phone_no">
            </div>
            <div class="flex flex-col">
                <p class="text-sm font-medium text-slate-500">Alamat</p>
                <textarea class="mt-2 w-full rounded-lg border px-3 py-2" row="3" wire:model="address" name="address" id="address"></textarea>
            </div>

            <input type="text" class="mt-2 w-full rounded-lg border px-3 py-2 hidden" name="retail_price" id="retail_price" value="{{ $retail_price }}">
            <input type="text" class="mt-2 w-full rounded-lg border px-3 py-2 hidden" name="paid_price" id="paid_price" value="{{ $paid_price }}">

            <div class="flex flex-col">
                <p class="text-sm font-medium text-slate-500">Jumlah Kad</p>
                <select class="mt-2 w-full rounded-lg border px-3 py-2" wire:model="card_amount" name="card_amount" id="card_amount" wire:click="selectCardAmount()">
                    <option value="100">100 Kad</option>
                    <option value="300">300 Kad</option>
                    <option value="500">500 Kad</option>
                    <option value="1000">1000 Kad</option>
                </select>
            </div>
        </div>
        <div class="flex flex-col gap-6 mt-12 lg:mt-0">
            <div class="flex border border-gray-200 rounded-lg overflow-hidden">
                <table class="table-auto w-full">
                    <tbody>
                        <tr class="border-b border-gray-200">
                            <td class="py-2 px-6">Retail</td>
                            <td class="py-2 px-6">RM {{ $retail_price }}</td>
                        </tr>
                        <tr class="border-b border-gray-200">
                            <td class="py-2 px-6">Discount</td>
                            <td class="py-2 px-6 text-red-600">- RM <span id="discount_amount">{{ $discount }}</span></td>
                        </tr>
                        <tr class="font-semibold">
                            <td class="py-2 px-6">Total</td>
                            <td class="py-2 px-6 text-green-600">RM <span id="total_amount">{{ $paid_price }}</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="flex flex-col mt-auto gap-6">
                <x-success-button type="submit" class="w-full rounded-lg border px-3 py-2 justify-center">Bayar</x-success-button>
                <div class="grid grid-cols-3 lg:grid-cols-5 gap-3 items-center justify-center bg-gray-100 p-3 rounded-lg">
                    <img src="{{ asset('images/payment/logo_maybank.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/logo_bankislam.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/logo_pb.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/logo_ocbc.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/logo_paypal.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/logo_fpx.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/tng.png') }}" class="h-12 m-auto">
                    <img src="{{ asset('images/payment/logo_grabpay.png') }}" class="m-auto">
                    <img src="{{ asset('images/payment/logo_boost.png') }}" class="m-auto">
                </div>
            </div>
        </div>
    </form>

    <script type="text/javascript">
        // document.addEventListener('livewire:load', function () {
        //     Livewire.on('discount', function (amount) {
        //         document.getElementById('discount_amount').innerHTML = amount;
        //         document.getElementById('total_amount').innerHTML = 312 - amount;
        //     });
        // });

        function submitPay() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: "/purchase/post-checkout",
                dataType: 'json',
                data: {
                    customer_name: customer_name.value,
                    email: email.value,
                    phone: phone_no.value,
                    customer_address: address.value,
                    card_amount: card_amount.value,
                    theme_code: 'service_print_card',
                    discount_code: 'system_dafault',
                    retail_price: retail_price.value,
                    paid_price: paid_price.value,
                },
                success: function(result) {
                    console.log(result);

                    if (result.err == 0) {
                        window.location.href = result.url;
                    } else {
                        $('#for-checkout').html(result.msg);
                    }
                },
                error: function(xhr, status, err) {
                    console.log(err);
                }
            });
        }
    </script>
</div>
