<div class="w-full max-w-2xl mx-auto bg-white border border-gray-400 lg:p-8 rounded-xl overflow-hidden">
    <div class="px-4 py-2 text-center bg-primary-600 text-white w-full flex items-center gap-4">
        <div class="rounded-full w-12 h-12 bg-white overflow-hidden">
            <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo" class="w-full h-full object-contain">
        </div>
        <div class="flex flex-col flex-grow text-left">
            <p>Ejen AI KKD</p>
            <div class="text-xs">Online</div>
        </div>
    </div>
    <div class="flex flex-col gap-4 p-4">

        <div class="flex flex-col lg:flex-row gap-2 lg:gap-4">
            <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo"
                class="w-8 h-8 rounded-full object-contain">
            <div class="flex flex-col pt-1">
                <p>Hello! Saya Ejen AI Kad Kahwin Digital. Perlukan bantuan?</p>
                <div class="flex flex-col lg:flex-row gap-2 mt-2 flex-wrap">
                    <button wire:click="step1"
                        class="flex-shrink-0 px-3 py-1 border border-primary-600 hover:bg-gray-100 text-primary-600 rounded-full">Saya
                        nak buat kad kahwin
                        digital.</button>
                    <a href="{{ route('filament.app.resources.cards.index') }}"
                        class="flex-shrink-0 px-3 py-1 border border-gray-400 hover:bg-gray-100 rounded-full text-center">Lihat
                        semua kad kahwin
                        saya.</a>
                    <a href="{{ route('theme.index') }}"
                        class="flex-shrink-0 px-3 py-1 border border-gray-400 hover:bg-gray-100 rounded-full text-center">Lihat
                        theme design kad
                        kahwin.</a>
                </div>
            </div>
        </div>

        @if ($current_step == 1 || $current_step == 2)
            <div class="rounded-md bg-gray-100 px-4 py-2 max-w-max ml-auto">
                Saya nak buat kad kahwin digital.
            </div>
        @endif

        @if ($current_step == -1)
            <div class="flex flex-col lg:flex-row gap-2 lg:gap-4">
                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo"
                    class="w-8 h-8 rounded-full object-contain">
                <div class="flex flex-col pt-1">
                    <p>Akaun anda sudah mencapai jumlah kad maksimum ( {{ $all_cards }} / {{ $max_cards }} )</p>
                    <div class="flex flex-col lg:flex-row gap-2 mt-2 flex-wrap">
                        <a href="{{ route('filament.app.resources.cards.index') }}"
                            class="flex-shrink-0 px-3 py-1 border border-gray-400 hover:bg-gray-100 rounded-full text-center">Lihat
                            semua kad kahwin
                            saya.</a>
                        <a href="{{ route('theme.index') }}"
                            class="flex-shrink-0 px-3 py-1 border border-gray-400 hover:bg-gray-100 rounded-full text-center">Lihat
                            theme design kad
                            kahwin.</a>
                    </div>
                </div>
            </div>
        @endif

        @if ($current_step == 1 || $current_step == 2)
            <div class="flex flex-col lg:flex-row gap-2 lg:gap-4">
                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo"
                    class="w-8 h-8 rounded-full object-contain">
                <div class="flex flex-col pt-1">
                    <p>Untuk membuat kad kahwin digital, sila isi butiran dibawah:</p>
                    <form class="grid gap-4 mt-2 bg-gray-100 p-4 rounded-lg shadow" wire:submit="step2">
                        <div class="flex flex-col gap-2">
                            <label class="text-sm">Nama pendek pengantin lelaki</label>
                            <input class="rounded-lg" wire:model="card_male_name_short" required
                                {{ $form_disabled ?? 'disabled' }} />
                        </div>
                        <div class="flex flex-col gap-2">
                            <label class="text-sm">Nama pendek pengantin perempuan</label>
                            <input class="rounded-lg" wire:model="card_female_name_short" required
                                {{ $form_disabled ?? 'disabled' }} />
                        </div>
                        <div class="flex flex-col gap-2">
                            <label class="text-sm">Nama penuh pengantin lelaki</label>
                            <input class="rounded-lg" wire:model="card_male_name_full" required
                                {{ $form_disabled ?? 'disabled' }} />
                        </div>
                        <div class="flex flex-col gap-2">
                            <label class="text-sm">Nama penuh pengantin perempuan</label>
                            <input class="rounded-lg" wire:model="card_female_name_full" required
                                {{ $form_disabled ?? 'disabled' }} />
                        </div>
                        <div class="flex flex-col gap-2">
                            <label class="text-sm">Tarikh majlis</label>
                            <input type="date" class="rounded-lg" wire:model="card_date" required
                                {{ $form_disabled ?? 'disabled' }} />
                        </div>
                        <button type="submit"
                            class="px-3 py-1 bg-primary-600 hover:bg-primary-700 text-white rounded-full"
                            {{ $form_disabled ?? 'disabled' }}>
                            Simpan
                        </button>
                    </form>
                </div>
            </div>
        @endif

        @if ($current_step == 2)
            <div class="flex flex-col lg:flex-row gap-2 lg:gap-4">
                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo"
                    class="w-8 h-8 rounded-full object-contain">
                <div class="flex flex-col pt-1">
                    <p>Tahniah! kad kahwin digital anda telah siap</p>
                    <div class="rounded-lg overflow-hidden shadow mt-2" x-data="{ openMore: false }">
                        <div class="relative">
                            <img src="{{ url('/theme/' . $card->theme_code . '/preview.jpg') }}" class="w-full">
                            <div class="absolute bottom-0 right-0 text-center w-full h-full flex-col p-4 text-white flex items-center justify-end"
                                style="background-image: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.75));">
                                <div class="flex-grow w-full relative">
                                    <a href="{{ route('cards.print', $card->id) }}"
                                        class="px-4 w-full h-10 flex text-sm font-bold bg-white text-black hover:bg-gray-100 flex items-center justify-center max-w-min shadow-lg rounded-bl-lg absolute -top-4 -right-4">
                                        <x-heroicon-o-printer class="h-4 mr-1" />Print/PDF
                                    </a>
                                </div>
                                <div class="w-12 mb-4"><x-heroicon-s-envelope-open class="shadow-lg" /></div>
                                <p>{{ $card->male_short_name }} & {{ $card->female_short_name }}</p>
                                <p>{{ date('d M Y', strtotime($card->date_masihi)) }}</p>
                            </div>
                            <div class="absolute top-0 left-0 w-full h-full bg-white flex flex-col" x-show="openMore">
                                <div class="p-4 flex items-center justify-center border-b bg-gray-100">More Options
                                </div>
                                <div class="flex-grow flex flex-col overflow-auto">
                                    <a href="https://www.facebook.com/sharer.php?u={{ url('/cards/' . $card->id) }}"
                                        class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                        <p class="w-12 py-3 text-center text-lg">
                                            <x-fab-facebook class="h-6" />
                                        </p>
                                        <div class="flex items-center">
                                            Facebook
                                        </div>
                                    </a>
                                    <a href="https://twitter.com/share?url={{ url('/cards/' . $card->id) }}&text=Kad%20Kahwin%20Digital&hashtags=kkd"
                                        class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                        <p class="w-12 py-3 text-center text-lg">
                                            <x-fab-twitter class="h-6" />
                                        </p>
                                        <div class="flex items-center">
                                            Twitter / X
                                        </div>
                                    </a>
                                    <a href="https://wa.me/?text=Kad%20Kahwin%20Digital%20-%20{{ url('/cards/' . $card->id) }}"
                                        class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                        <p class="w-12 py-3 text-center text-lg">
                                            <x-fab-whatsapp class="h-6" />
                                        </p>
                                        <div class="flex items-center">
                                            WhatsApp
                                        </div>
                                    </a>
                                    <a href="{{ route('cards.print', $card->id) }}"
                                        class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                                        <p class="w-12 py-3 text-center text-lg">
                                            <x-heroicon-o-printer class="h-6" />
                                        </p>
                                        <div class="flex items-center">
                                            Print
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white grid grid-cols-3 text-black text-sm font-semibold border-t">
                            <a href="{{ url('/cards/' . $card->id) }}"
                                class="p-4 flex items-center justify-center hover:bg-gray-100 border-r"
                                target="_blank">
                                View
                            </a>
                            <a href="{{ url('/app/cards/' . $card->id . '/edit') }}"
                                class="p-4 flex items-center justify-center hover:bg-gray-100 border-r">
                                Edit
                            </a>
                            <button class="p-4 flex items-center justify-center hover:bg-gray-100"
                                @click="openMore = !openMore">
                                More
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div wire:loading>
            <div class="flex flex-col lg:flex-row gap-2 lg:gap-4 animate-pulse">
                <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo"
                    class="w-8 h-8 rounded-full object-contain">
                <div class="flex flex-col pt-1 italic">
                    <p>Sebentar...</p>
                </div>
            </div>
        </div>


    </div>
</div>
