<div class="flex flex-col max-w-sm w-full">
    <div class="px-4 py-2 text-center bg-prime text-white w-full flex items-center gap-4">
        <div class="rounded-full w-12 h-12 bg-white overflow-hidden">
            <img src="{{ asset('images/chat_ai_kkd_profile.png') }}" alt="KKD Logo" class="w-full h-full object-contain">
        </div>
        <div class="flex flex-col flex-grow text-left">
            <p>Chat AI KKD</p>
            <div class="text-xs">Online</div>
        </div>
    </div>
    <div id="chat-container" class="p-4 h-80 overflow-auto">

        <div class="pr-8 pb-2">
            <div class="p-2 bg-gray-100 rounded-lg max-w-fit mr-auto shadow">
                <p>Hello! I am Chat AI KKD. You can ask me to get information.</p>
            </div>
        </div>

        {!! $reply !!}

    </div>
    <div class="p-4 border-t text-sm flex overflow-x-auto space-x-2">
        <button class="flex-shrink-0 rounded-full px-3 py-1 border border-gray-300 hover:bg-gray-100"
            wire:click="ask(1)">When is it?</button>
        <button class="flex-shrink-0 rounded-full px-3 py-1 border border-gray-300 hover:bg-gray-100"
            wire:click="ask(2)">Where is it?</button>
        <button class="flex-shrink-0 rounded-full px-3 py-1 border border-gray-300 hover:bg-gray-100"
            wire:click="ask(3)">What's the schedule?</button>
    </div>

    <script>
        document.addEventListener('livewire:initialized', () => {
            var elem = document.getElementById('chat-container');
            Livewire.hook('morph.updated', () => {
                elem.scrollTo({ top: elem.scrollHeight, behavior: "smooth" })
            });
        })
    </script>
</div>
