<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Buy Now') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="w-full grid lg:grid-cols-2">
                    <img src="{{ url('/theme/' . $theme->code . '/sneak_view.jpg') }}" class="w-full">
                    <form id="checkout-form" method="post" onsubmit="submitPay(); return false;"
                        class="p-6 flex flex-col w-full">
                        <h1 class="font-bold text-2xl mb-2">{{ $theme->name }}</h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm">{{ $theme->description }}</p>
                        <div class="my-auto py-4">
                            <p class="text-sm mb-2 font-semibold text-gray-500">Discount:</p>
                            <div class="flex flex-col lg:flex-row gap-3">
                                <input type="text" name="discount_code" id="discount_code"
                                    class="h-12 px-6 flex-grow flex justify-center border rounded-lg" placeholder="Code">
                                <div>
                                    <x-secondary-button type="button" onclick="applyDiscount()"
                                        class="h-full w-full flex justify-center">
                                        Apply
                                    </x-secondary-button>
                                </div>
                            </div>
                            <div id="for-discount" class="font-bold text-sm mt-2"></div>
                            <p class="text-sm mb-2 mt-6 font-semibold text-gray-500">Summary:</p>
                            <div class="flex border border-gray-200 rounded-lg overflow-hidden mb-2">
                                <table class="table-auto w-full">
                                    <tbody>
                                        <tr class="border-b border-gray-200">
                                            <td class="py-2 px-6">Retail</td>
                                            <td class="py-2 px-6">RM {{ $theme->price }}</td>
                                        </tr>
                                        <tr class="border-b border-gray-200">
                                            <td class="py-2 px-6">Discount</td>
                                            <td class="py-2 px-6">RM <span id="discount_amount">0</span></td>
                                        </tr>
                                        <tr class="font-semibold">
                                            <td class="py-2 px-6">Total</td>
                                            <td class="py-2 px-6">RM <span id="total_amount">116</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div>
                            <div class="hidden">
                                @csrf
                                <input type="text" name="email" id="email" value="{{ Auth::user()->email }}">
                                <input type="text" name="phone" id="phone" value="">
                                <input type="text" name="theme_code" id="theme_code" value="{{ $theme->code }}">
                                <input type="text" name="retail_price" id="retail_price" value="{{ $theme->price }}">
                                <input type="text" name="paid_price" id="paid_price" value="116">
                            </div>
                            <x-success-button type="button" onclick="submitPay()" class="w-full flex justify-center">
                                Pay Now
                            </x-success-button>
                            <div class="grid grid-cols-3 lg:grid-cols-5 gap-3 items-center justify-center bg-gray-100 p-3 rounded-lg mt-6">
                                <img src="{{ asset('images/payment/logo_maybank.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/logo_bankislam.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/logo_pb.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/logo_ocbc.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/logo_paypal.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/logo_fpx.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/tng.png') }}" class="h-12 m-auto">
                                <img src="{{ asset('images/payment/logo_grabpay.png') }}" class="m-auto">
                                <img src="{{ asset('images/payment/logo_boost.png') }}" class="m-auto">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function submitPay() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: "/purchase/post-checkout",
                dataType: 'json',
                data: {
                    email: email.value,
                    phone: phone.value,
                    theme_code: theme_code.value,
                    discount_code: discount_code.value,
                    retail_price: retail_price.value,
                    paid_price: paid_price.value
                },
                success: function(result) {
                    console.log(result);

                    if (result.err == 0) {
                        window.location.href = result.url;
                    } else {
                        $('#for-checkout').html(result.msg);
                    }
                },
                error: function(xhr, status, err) {
                    console.log(err);
                }
            });
        }

        function applyDiscount() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: "/purchase/discount-check",
                dataType: 'json',
                data: {
                    discount_code: discount_code.value
                },
                success: function(result) {
                    if (result.err == 0) {
                        var price = parseInt('116', 10);
                        var total = price - result.amount;

                        $('#discount_amount').html(result.amount);
                        $('#total_amount').html(total);
                        $('#paid_price').val(total);
                        $('#for-discount').html(result.msg);
                    } else {
                        $('#for-discount').html(result.msg);

                    }

                }
            });
        }
    </script>
</x-app-layout>
