<div class="w-100" style="padding-top: calc(100% + 3rem);"></div>
<div class="absolute w-full -mt-4 left-0 rounded-xl overflow-hidden" x-data="{ openMore: false }">
    <div class="relative">
        <img src="{{ url('/theme/' . $getRecord()->theme_code . '/preview.jpg') }}" class="w-full">
        <div class="absolute bottom-0 right-0 text-center w-full h-full flex-col p-4 text-white flex items-center justify-end"
            style="background-image: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.75));">
            <div class="flex-grow w-full relative">
                <a href="{{ route('cards.print', $getRecord()->id) }}"
                    class="px-4 w-full h-10 flex text-sm font-bold bg-white text-black hover:bg-gray-100 flex items-center justify-center max-w-min shadow-lg rounded-bl-lg absolute -top-4 -right-4">
                    <x-heroicon-o-printer class="h-4 mr-1" />Print
                </a>
            </div>
            <div class="w-12 mb-4"><x-heroicon-s-envelope-open class="shadow-lg" /></div>
            <p>{{ $getRecord()->male_short_name }} & {{ $getRecord()->female_short_name }}</p>
            <p>{{ date('d M Y', strtotime($getRecord()->date_masihi)) }}</p>
        </div>
        <div class="absolute top-0 left-0 w-full h-full bg-white flex flex-col" x-show="openMore">
            <div class="p-4 flex items-center justify-center border-b bg-gray-100">More Options</div>
            <div class="flex-grow flex flex-col overflow-auto">
                <a href="{{ route('cards.metaverse', $getRecord()->id) }}"
                    class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                    <p class="w-12 py-3 text-center text-lg">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" xmlns="http://www.w3.org/2000/svg" class="h-6">
                            <g><path d="M2 5C8 9 16 9 22 5V19C16 15 8 15 2 19V5ZM8 13 12 11 12 13 16 11"></path></g>
                        </svg>
                    </p>
                    <div class="flex items-center">
                        3D Metaverse
                    </div>
                </a>
                <a href="https://www.facebook.com/sharer.php?u={{ url('/cards/' . $getRecord()->id) }}"
                    class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                    <p class="w-12 py-3 text-center text-lg">
                        <x-fab-facebook class="h-6" />
                    </p>
                    <div class="flex items-center">
                        Facebook
                    </div>
                </a>
                <a href="https://twitter.com/share?url={{ url('/cards/' . $getRecord()->id) }}&text=Kad%20Kahwin%20Digital&hashtags=kkd"
                    class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                    <p class="w-12 py-3 text-center text-lg">
                        <x-fab-twitter class="h-6" />
                    </p>
                    <div class="flex items-center">
                        Twitter / X
                    </div>
                </a>
                <a href="https://wa.me/?text=Kad%20Kahwin%20Digital%20-%20{{ url('/cards/' . $getRecord()->id) }}"
                    class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                    <p class="w-12 py-3 text-center text-lg">
                        <x-fab-whatsapp class="h-6" />
                    </p>
                    <div class="flex items-center">
                        WhatsApp
                    </div>
                </a>
                <a href="{{ route('cards.print', $getRecord()->id) }}"
                    class="px-6 w-full flex hover:bg-gray-100" target="_blank">
                    <p class="w-12 py-3 text-center text-lg">
                        <x-heroicon-o-printer class="h-6" />
                    </p>
                    <div class="flex items-center">
                        Print/PDF
                    </div>
                </a>
            </div>
        </div>
    </div>
    <div class="bg-white grid grid-cols-3 text-black text-sm font-semibold border-t" style="height: 3rem">
        <a href="{{ url('/cards/' . $getRecord()->id) }}"
            class="flex items-center justify-center hover:bg-gray-100 border-r" target="_blank">
            View
        </a>
        <a href="{{ url('/app/cards/' . $getRecord()->id . '/edit') }}"
            class="flex items-center justify-center hover:bg-gray-100 border-r">
            Edit
        </a>
        <button class="flex items-center justify-center hover:bg-gray-100" @click="openMore = !openMore">
            More
        </button>
    </div>
</div>
