<x-app-layout>

    <div class="pb-12 lg:py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 flex flex-col">

            <div class="bg-white shadow grid grid-cols-1 lg:grid-cols-3 mb-12 rounded-xl"
                style="background-image: url('{{ url('/images/bg_banner.jpg') }}'); background-size:cover; background-position: bottom;">
                <div class="order-2 lg:order-1 px-12 lg:px-0">
                    <img src="{{ url('/images/model_say_good.png') }}" class="lg:mt-12 w-full max-w-xs mx-auto lg:mr-0">
                </div>
                <div class="p-12 order-1 lg:order-2 flex flex-col justify-center lg:col-span-2">
                    <img src="{{ url('/images/promo_harga_special.png') }}" class="max-w-sm mb-6 mx-auto lg:mx-0 w-full">
                    <h1 class="font-bold text-2xl lg:text-4xl mb-6">Diskaun 75% <br>Untuk Semua Tema & Design Menarik!
                    </h1>
                    <p class="font-semibold">Gunakan Discount Code <span
                            class="bg-red-700 text-white rounded-full py-1 px-2">OFF75</span> Untuk
                        Dapatkan Potongan Harga Sehingga 75%. Pelbagai Pilihan Sampai Rambang Mata.</p>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6 px-6 lg:px-0 mb-6">
                @foreach ($popular_themes as $theme)
                    <a href="{{ route('theme.show', $theme->code) }}" class="flex flex-col">
                        <div class="rounded-lg mb-2 shadow p-1 bg-green-600 relative overflow-hidden">
                            <img src="{{ url('/theme/' . $theme->code . '/sneak_view.jpg') }}"
                                class="w-full rounded-md">
                            <div
                                class="bg-green-600 absolute top-0 right-0 px-3 py-2 text-xs text-yellow-300 font-bold rounded-bl-xl">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                            <div
                                class="bg-green-600 absolute bottom-0 left-0 px-3 py-2 text-xs text-white font-bold rounded-tr-xl">
                                POPULAR CHOICE</div>
                        </div>

                        <p class="font-semibold text-lg">{{ $theme->name }}</p>
                        <p class="text-sm">{{ $theme->category }}</p>
                    </a>
                @endforeach
                <a href="{{ route('theme.show', 'custom') }}" class="flex flex-col">
                    <div class="rounded-lg mb-2 shadow p-1 bg-green-600 relative overflow-hidden">
                        <img src="{{ url('/theme/custom/sneak_view.jpg') }}"
                            class="w-full rounded-md">
                        <div
                            class="bg-green-600 absolute top-0 right-0 px-3 py-2 text-xs text-yellow-300 font-bold rounded-bl-xl">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <div
                            class="bg-green-600 absolute bottom-0 left-0 px-3 py-2 text-xs text-white font-bold rounded-tr-xl">
                            POPULAR CHOICE</div>
                    </div>

                    <p class="font-semibold text-lg">Custom</p>
                    <p class="text-sm">Guna design sendiri</p>
                </a>
            </div>

            <div class="grid grid-cols-2 lg:grid-cols-4 gap-6 px-6 lg:px-0 mb-6">
                @foreach ($themes as $theme)
                    <a href="{{ route('theme.show', $theme->code) }}" class="flex flex-col">
                        <img src="{{ url('/theme/' . $theme->code . '/sneak_view.jpg') }}"
                            class="w-full rounded-lg mb-2 shadow">
                        <p class="font-semibold text-lg">{{ $theme->name }}</p>
                        <p class="text-sm">{{ $theme->category }}</p>
                    </a>
                @endforeach
            </div>

            <div class="px-6 lg:px-0">
                {{ $themes->links() }}
            </div>

        </div>
    </div>

</x-app-layout>
